/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os;

import java.io.FileDescriptor;
import java.lang.reflect.Field;
import one.nio.os.NativeLibrary;
import one.nio.util.JavaInternals;

public final class Mem {
    public static final boolean IS_SUPPORTED = NativeLibrary.IS_SUPPORTED;
    private static final Field fdField = JavaInternals.getField(FileDescriptor.class, "fd");
    public static final int PROT_NONE = 0;
    public static final int PROT_READ = 1;
    public static final int PROT_WRITE = 2;
    public static final int PROT_EXEC = 4;
    public static final int MAP_SHARED = 1;
    public static final int MAP_PRIVATE = 2;
    public static final int MAP_FIXED = 16;
    public static final int MAP_ANONYMOUS = 32;
    public static final int MAP_GROWSDOWN = 256;
    public static final int MAP_LOCKED = 8192;
    public static final int MAP_NORESERVE = 16384;
    public static final int MAP_POPULATE = 32768;
    public static final int MAP_NONBLOCK = 65536;
    public static final int MAP_STACK = 131072;
    public static final int MAP_HUGETLB = 262144;
    public static final int MREMAP_MAYMOVE = 1;
    public static final int MREMAP_FIXED = 2;
    public static final int MS_ASYNC = 1;
    public static final int MS_INVALIDATE = 2;
    public static final int MS_SYNC = 4;
    public static final int MCL_CURRENT = 1;
    public static final int MCL_FUTURE = 2;
    public static final int POSIX_MADV_NORMAL = 0;
    public static final int POSIX_MADV_RANDOM = 1;
    public static final int POSIX_MADV_SEQUENTIAL = 2;
    public static final int POSIX_MADV_WILLNEED = 3;
    public static final int POSIX_MADV_DONTNEED = 4;
    public static final int POSIX_FADV_NORMAL = 0;
    public static final int POSIX_FADV_RANDOM = 1;
    public static final int POSIX_FADV_SEQUENTIAL = 2;
    public static final int POSIX_FADV_WILLNEED = 3;
    public static final int POSIX_FADV_DONTNEED = 4;
    public static final int POSIX_FADV_NOREUSE = 5;

    public static native long mmap(long var0, long var2, int var4, int var5, int var6, long var7);

    public static native long mremap(long var0, long var2, long var4, int var6);

    public static native int munmap(long var0, long var2);

    public static native int mprotect(long var0, long var2, int var4);

    public static long mmap(long addr, long length, int prot, int flags, FileDescriptor fd, long offset) {
        return Mem.mmap(addr, length, prot, flags, Mem.getFD(fd), offset);
    }

    public static native int msync(long var0, long var2, int var4);

    public static native int mlock(long var0, long var2);

    public static native int munlock(long var0, long var2);

    public static native int mlockall(int var0);

    public static native int munlockall();

    public static native int posix_madvise(long var0, long var2, int var4);

    public static native int posix_fadvise(int var0, long var1, long var3, int var5);

    public static int posix_fadvise(FileDescriptor fd, long offset, long len, int advice) {
        return Mem.posix_fadvise(Mem.getFD(fd), offset, len, advice);
    }

    public static int getFD(FileDescriptor fd) {
        try {
            return fdField.getInt(fd);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Should not happen");
        }
    }
}

