/*
 * Decompiled with CFR 0.152.
 */
package one.nio.pool;

import one.nio.mgt.Management;
import one.nio.net.ConnectionString;
import one.nio.net.Socket;
import one.nio.net.SslContext;
import one.nio.pool.Pool;
import one.nio.pool.PoolException;
import one.nio.pool.SocketPoolMXBean;

public class SocketPool
extends Pool<Socket>
implements SocketPoolMXBean {
    protected String host;
    protected int port;
    protected int readTimeout;
    protected int connectTimeout;
    protected int tos;
    protected SslContext sslContext;

    public SocketPool(ConnectionString conn) {
        super(conn.getIntParam("clientMinPoolSize", 0), conn.getIntParam("clientMaxPoolSize", 10), conn.getIntParam("timeout", 3000));
        this.host = conn.getHost();
        this.port = conn.getPort();
        this.readTimeout = conn.getIntParam("readTimeout", this.timeout);
        this.connectTimeout = conn.getIntParam("connectTimeout", 1000);
        this.tos = conn.getIntParam("tos", 0);
        this.setProperties(conn);
        this.initialize();
        if (conn.getBooleanParam("jmx", false)) {
            Management.registerMXBean(this, "one.nio.pool:type=SocketPool,host=" + this.host + ",port=" + this.port);
        }
    }

    protected void setProperties(ConnectionString conn) {
        if ("ssl".equals(conn.getProtocol())) {
            this.sslContext = SslContext.getDefault();
        }
    }

    @Override
    public String name() {
        return "SocketPool[" + this.host + ':' + this.port + ']';
    }

    @Override
    public int getTimeouts() {
        return this.timeouts;
    }

    @Override
    public int getWaitingThreads() {
        return this.waitingThreads;
    }

    @Override
    public int getBusyCount() {
        return this.createdCount - this.size();
    }

    @Override
    public int getIdleCount() {
        return this.size();
    }

    @Override
    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Socket createObject() throws PoolException {
        Socket socket = null;
        try {
            socket = Socket.create();
            socket.setKeepAlive(true);
            socket.setNoDelay(true);
            if (this.tos != 0) {
                socket.setTos(this.tos);
            }
            socket.setTimeout(this.connectTimeout);
            socket.connect(this.host, this.port);
            socket.setTimeout(this.readTimeout);
            if (this.sslContext != null) {
                socket = socket.ssl(this.sslContext);
            }
            return socket;
        }
        catch (Exception e) {
            if (socket != null) {
                socket.close();
            }
            throw new PoolException(this.name() + " createObject failed", e);
        }
    }

    @Override
    public void destroyObject(Socket socket) {
        socket.close();
    }
}

