/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Default;
import one.nio.serial.Origin;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.serial.gen.StubGenerator;

public class EnumSerializer
extends Serializer<Enum> {
    static final AtomicInteger enumCountMismatches = new AtomicInteger();
    static final AtomicInteger enumMissedConstants = new AtomicInteger();
    private Enum[] values = (Enum[])this.cls().getEnumConstants();

    EnumSerializer(Class cls) {
        super(cls);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Enum[] ownValues = (Enum[])this.cls().getEnumConstants();
        out.writeShort(ownValues.length);
        for (Enum v : ownValues) {
            out.writeUTF(v.name());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        String[] constants = new String[in.readUnsignedShort()];
        for (int i2 = 0; i2 < constants.length; ++i2) {
            constants[i2] = in.readUTF();
        }
        try {
            super.readExternal(in);
        }
        catch (ClassNotFoundException e) {
            if ((Repository.getOptions() & 8) == 0) {
                throw e;
            }
            this.cls = StubGenerator.generateEnum(this.uniqueName("Enum"), constants);
            this.origin = Origin.GENERATED;
        }
        Enum[] ownValues = (Enum[])this.cls().getEnumConstants();
        if (ownValues.length != constants.length) {
            Repository.log.warn((Object)("[" + Long.toHexString(this.uid) + "] Enum count mismatch for " + this.descriptor + ": " + ownValues.length + " local vs. " + constants.length + " stream constants"));
            enumCountMismatches.incrementAndGet();
        }
        EnumSet usedConstants = EnumSet.noneOf(this.cls);
        this.values = new Enum[constants.length];
        for (i = 0; i < constants.length; ++i) {
            this.values[i] = this.findMatch(constants[i], usedConstants);
        }
        for (i = 0; i < this.values.length && i < ownValues.length; ++i) {
            if (this.values[i] != null || usedConstants.contains(ownValues[i])) continue;
            this.values[i] = ownValues[i];
        }
    }

    @Override
    public void skipExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int constants = in.readUnsignedShort();
        for (int i = 0; i < constants; ++i) {
            in.skipBytes(in.readUnsignedShort());
        }
    }

    @Override
    public void calcSize(Enum obj, CalcSizeStream css) {
        css.count += 2;
    }

    @Override
    public void write(Enum obj, DataStream out) throws IOException {
        out.writeShort(obj.ordinal());
    }

    @Override
    public Enum read(DataStream in) throws IOException {
        Enum result = this.values[in.readUnsignedShort()];
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(2);
    }

    @Override
    public void toJson(Enum obj, StringBuilder builder) {
        builder.append('\"').append(obj.name()).append('\"');
    }

    private Enum findMatch(String name, EnumSet found) {
        try {
            Object localConstant = Enum.valueOf(this.cls, name);
            found.add(localConstant);
            return localConstant;
        }
        catch (IllegalArgumentException e) {
            Repository.log.warn((Object)("[" + Long.toHexString(this.uid) + "] Missed local enum constant " + this.descriptor + '.' + name));
            enumCountMismatches.incrementAndGet();
            Default defaultName = this.cls().getAnnotation(Default.class);
            return defaultName == null ? null : (Enum)Enum.valueOf(this.cls, defaultName.value());
        }
    }
}

