/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Json;
import one.nio.serial.Origin;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.serial.gen.StubGenerator;

public class MapSerializer
extends Serializer<Map> {
    private Constructor constructor = this.findConstructor();

    MapSerializer(Class cls) {
        super(cls);
        this.constructor.setAccessible(true);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(in);
        }
        catch (ClassNotFoundException e) {
            if ((Repository.getOptions() & 4) == 0) {
                throw e;
            }
            this.cls = StubGenerator.generateRegular(this.uniqueName("Map"), "java/util/HashMap", null);
            this.origin = Origin.GENERATED;
        }
        this.constructor = this.findConstructor();
        this.constructor.setAccessible(true);
    }

    @Override
    public void calcSize(Map obj, CalcSizeStream css) throws IOException {
        css.count += 4;
        for (Map.Entry e : obj.entrySet()) {
            css.writeObject(e.getKey());
            css.writeObject(e.getValue());
        }
    }

    @Override
    public void write(Map obj, DataStream out) throws IOException {
        out.writeInt(obj.size());
        for (Map.Entry e : obj.entrySet()) {
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
        }
    }

    @Override
    public Map read(DataStream in) throws IOException, ClassNotFoundException {
        Map result;
        try {
            result = (Map)this.constructor.newInstance(new Object[0]);
            in.register(result);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            result.put(in.readObject(), in.readObject());
        }
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            in.readObject();
            in.readObject();
        }
    }

    @Override
    public void toJson(Map obj, StringBuilder builder) throws IOException {
        builder.append('{');
        boolean firstWritten = false;
        for (Map.Entry entry : obj.entrySet()) {
            if (firstWritten) {
                builder.append(',');
            } else {
                firstWritten = true;
            }
            Json.appendString(builder, entry.getKey().toString());
            builder.append(':');
            Json.appendObject(builder, entry.getValue());
        }
        builder.append('}');
    }

    private Constructor findConstructor() {
        try {
            return this.cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Class implementation = ConcurrentNavigableMap.class.isAssignableFrom(this.cls) ? ConcurrentSkipListMap.class : (ConcurrentMap.class.isAssignableFrom(this.cls) ? ConcurrentHashMap.class : (SortedMap.class.isAssignableFrom(this.cls) ? TreeMap.class : HashMap.class));
            this.generateUid();
            Repository.log.warn((Object)("[" + Long.toHexString(this.uid) + "] No default constructor for " + this.descriptor + ", changed type to " + implementation.getName()));
            try {
                return implementation.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                return null;
            }
        }
    }

    static boolean isValidType(Class<?> type) {
        try {
            type.getConstructor(new Class[0]);
            return (type.getModifiers() & 0x400) == 0;
        }
        catch (NoSuchMethodException e) {
            return type == Map.class || type == SortedMap.class || type == NavigableMap.class || type == ConcurrentMap.class || type == ConcurrentNavigableMap.class;
        }
    }
}

