/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Json;
import one.nio.serial.Serializer;
import one.nio.util.Utf8;

class StringSerializer
extends Serializer<String> {
    StringSerializer() {
        super(String.class);
    }

    @Override
    public void calcSize(String obj, CalcSizeStream css) {
        int length = Utf8.length(obj);
        css.count = css.count + (length + (length <= Short.MAX_VALUE ? 2 : 4));
    }

    @Override
    public void write(String obj, DataStream out) throws IOException {
        out.writeUTF(obj);
    }

    @Override
    public String read(DataStream in) throws IOException {
        String result = in.readUTF();
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        int length = in.readUnsignedShort();
        if (length > Short.MAX_VALUE) {
            length = (length & Short.MAX_VALUE) << 16 | in.readUnsignedShort();
        }
        in.skipBytes(length);
    }

    @Override
    public void toJson(String obj, StringBuilder builder) {
        Json.appendString(builder, obj);
    }
}

