/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial.gen;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.gen.BytecodeGenerator;
import one.nio.serial.Default;
import one.nio.serial.FieldDescriptor;
import one.nio.serial.JsonName;
import one.nio.serial.Repository;
import one.nio.serial.gen.FieldType;
import one.nio.util.JavaInternals;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DelegateGenerator
extends BytecodeGenerator {
    private static final AtomicInteger index = new AtomicInteger();

    public static byte[] generate(Class cls, FieldDescriptor[] fds, List<Field> defaultFields) {
        String className = "sun/reflect/Delegate" + index.getAndIncrement() + '_' + cls.getSimpleName();
        ClassWriter cv = new ClassWriter(3);
        cv.visit(50, 17, className, null, "sun/reflect/MagicAccessorImpl", new String[]{"one/nio/serial/gen/Delegate"});
        DelegateGenerator.generateConstructor((ClassVisitor)cv);
        DelegateGenerator.generateCalcSize((ClassVisitor)cv, cls, fds);
        DelegateGenerator.generateWrite((ClassVisitor)cv, cls, fds);
        DelegateGenerator.generateRead((ClassVisitor)cv, cls, fds, defaultFields);
        DelegateGenerator.generateSkip((ClassVisitor)cv, fds);
        DelegateGenerator.generateToJson((ClassVisitor)cv, fds);
        cv.visitEnd();
        return cv.toByteArray();
    }

    private static void generateConstructor(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "sun/reflect/MagicAccessorImpl", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateCalcSize(ClassVisitor cv, Class cls, FieldDescriptor[] fds) {
        MethodVisitor mv = cv.visitMethod(17, "calcSize", "(Ljava/lang/Object;Lone/nio/serial/CalcSizeStream;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        Method writeObjectMethod = JavaInternals.findMethodRecursively(cls, "writeObject", ObjectOutputStream.class);
        if (writeObjectMethod != null && !Repository.hasOptions(writeObjectMethod.getDeclaringClass(), 2)) {
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(178, "one/nio/serial/gen/NullObjectOutputStream", "INSTANCE", "Lone/nio/serial/gen/NullObjectOutputStream;");
            DelegateGenerator.emitInvoke(mv, writeObjectMethod);
        }
        int primitiveFieldsSize = 0;
        for (FieldDescriptor fd : fds) {
            Field ownField = fd.ownField();
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            if (srcType != FieldType.Object) {
                primitiveFieldsSize += srcType.dataSize;
                continue;
            }
            if (ownField == null) {
                ++primitiveFieldsSize;
                continue;
            }
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            if (fd.parentField() != null) {
                DelegateGenerator.emitGetField(mv, fd.parentField());
            }
            DelegateGenerator.emitGetField(mv, ownField);
            DelegateGenerator.emitTypeCast(mv, ownField.getType(), sourceClass);
            mv.visitMethodInsn(182, "one/nio/serial/CalcSizeStream", "writeObject", "(Ljava/lang/Object;)V");
        }
        if (primitiveFieldsSize != 0) {
            mv.visitVarInsn(25, 2);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, "one/nio/serial/CalcSizeStream", "count", "I");
            DelegateGenerator.emitInt(mv, primitiveFieldsSize);
            mv.visitInsn(96);
            mv.visitFieldInsn(181, "one/nio/serial/CalcSizeStream", "count", "I");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateWrite(ClassVisitor cv, Class cls, FieldDescriptor[] fds) {
        MethodVisitor mv = cv.visitMethod(17, "write", "(Ljava/lang/Object;Lone/nio/serial/DataStream;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        Method writeObjectMethod = JavaInternals.findMethodRecursively(cls, "writeObject", ObjectOutputStream.class);
        if (writeObjectMethod != null && !Repository.hasOptions(writeObjectMethod.getDeclaringClass(), 2)) {
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(178, "one/nio/serial/gen/NullObjectOutputStream", "INSTANCE", "Lone/nio/serial/gen/NullObjectOutputStream;");
            DelegateGenerator.emitInvoke(mv, writeObjectMethod);
        }
        for (FieldDescriptor fd : fds) {
            Field ownField = fd.ownField();
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            mv.visitVarInsn(25, 2);
            if (ownField == null) {
                mv.visitInsn(FieldType.Void.convertTo(srcType));
            } else {
                mv.visitVarInsn(25, 1);
                if (fd.parentField() != null) {
                    DelegateGenerator.emitGetField(mv, fd.parentField());
                }
                DelegateGenerator.emitGetField(mv, ownField);
                DelegateGenerator.emitTypeCast(mv, ownField.getType(), sourceClass);
            }
            mv.visitMethodInsn(182, "one/nio/serial/DataStream", srcType.writeMethod(), srcType.writeSignature());
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateRead(ClassVisitor cv, Class cls, FieldDescriptor[] fds, List<Field> defaultFields) {
        Method readObjectMethod;
        MethodVisitor mv = cv.visitMethod(17, "read", "(Lone/nio/serial/DataStream;)Ljava/lang/Object;", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(187, Type.getInternalName((Class)cls));
        mv.visitInsn(89);
        mv.visitVarInsn(58, 2);
        mv.visitMethodInsn(182, "one/nio/serial/DataStream", "register", "(Ljava/lang/Object;)V");
        ArrayList<Field> parents = new ArrayList<Field>(1);
        for (FieldDescriptor fd : fds) {
            Field ownField = fd.ownField();
            Field parentField = fd.parentField();
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            if (parentField != null && !parents.contains(parentField)) {
                parents.add(parentField);
                mv.visitFieldInsn(178, "one/nio/util/JavaInternals", "unsafe", "Lsun/misc/Unsafe;");
                mv.visitVarInsn(25, 2);
                mv.visitLdcInsn((Object)JavaInternals.unsafe.objectFieldOffset(parentField));
                mv.visitTypeInsn(187, Type.getInternalName(parentField.getType()));
                mv.visitMethodInsn(183, "sun/misc/Unsafe", "putObject", "(Ljava/lang/Object;JLjava/lang/Object;)V");
            }
            if (ownField == null) {
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "one/nio/serial/DataStream", srcType.readMethod(), srcType.readSignature());
                mv.visitInsn(srcType.convertTo(FieldType.Void));
                continue;
            }
            if (Modifier.isFinal(ownField.getModifiers())) {
                FieldType dstType = FieldType.valueOf(ownField.getType());
                mv.visitFieldInsn(178, "one/nio/util/JavaInternals", "unsafe", "Lsun/misc/Unsafe;");
                mv.visitVarInsn(25, 2);
                if (parentField != null) {
                    DelegateGenerator.emitGetField(mv, parentField);
                }
                mv.visitLdcInsn((Object)JavaInternals.unsafe.objectFieldOffset(ownField));
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "one/nio/serial/DataStream", srcType.readMethod(), srcType.readSignature());
                if (srcType == FieldType.Object) {
                    DelegateGenerator.emitTypeCast(mv, Object.class, sourceClass);
                }
                DelegateGenerator.emitTypeCast(mv, sourceClass, ownField.getType());
                mv.visitMethodInsn(183, "sun/misc/Unsafe", dstType.putMethod(), dstType.putSignature());
                continue;
            }
            mv.visitVarInsn(25, 2);
            if (parentField != null) {
                DelegateGenerator.emitGetField(mv, parentField);
            }
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "one/nio/serial/DataStream", srcType.readMethod(), srcType.readSignature());
            if (srcType == FieldType.Object) {
                DelegateGenerator.emitTypeCast(mv, Object.class, sourceClass);
            }
            DelegateGenerator.emitTypeCast(mv, sourceClass, ownField.getType());
            DelegateGenerator.emitPutField(mv, ownField);
        }
        if (defaultFields != null && !defaultFields.isEmpty()) {
            for (Field defaultField : defaultFields) {
                DelegateGenerator.setDefaultField(mv, defaultField);
            }
        }
        if ((readObjectMethod = JavaInternals.findMethodRecursively(cls, "readObject", ObjectInputStream.class)) != null && !Repository.hasOptions(readObjectMethod.getDeclaringClass(), 1)) {
            mv.visitVarInsn(25, 2);
            mv.visitFieldInsn(178, "one/nio/serial/gen/NullObjectInputStream", "INSTANCE", "Lone/nio/serial/gen/NullObjectInputStream;");
            DelegateGenerator.emitInvoke(mv, readObjectMethod);
        }
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateSkip(ClassVisitor cv, FieldDescriptor[] fds) {
        MethodVisitor mv = cv.visitMethod(17, "skip", "(Lone/nio/serial/DataStream;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        mv.visitCode();
        int skipSize = 0;
        for (FieldDescriptor fd : fds) {
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            if (srcType != FieldType.Object) {
                skipSize += srcType.dataSize;
                continue;
            }
            if (skipSize > 0) {
                mv.visitVarInsn(25, 1);
                DelegateGenerator.emitInt(mv, skipSize);
                mv.visitMethodInsn(182, "one/nio/serial/DataStream", "skipBytes", "(I)I");
                mv.visitInsn(87);
                skipSize = 0;
            }
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "one/nio/serial/DataStream", "readObject", "()Ljava/lang/Object;");
            mv.visitInsn(87);
        }
        if (skipSize > 0) {
            mv.visitVarInsn(25, 1);
            DelegateGenerator.emitInt(mv, skipSize);
            mv.visitMethodInsn(182, "one/nio/serial/DataStream", "skipBytes", "(I)I");
            mv.visitInsn(87);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateToJson(ClassVisitor cv, FieldDescriptor[] fds) {
        MethodVisitor mv = cv.visitMethod(17, "toJson", "(Ljava/lang/Object;Ljava/lang/StringBuilder;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        boolean firstWritten = false;
        mv.visitVarInsn(25, 2);
        block4: for (FieldDescriptor fd : fds) {
            Field ownField = fd.ownField();
            if (ownField == null) continue;
            JsonName jsonName = ownField.getAnnotation(JsonName.class);
            String fieldName = jsonName != null ? jsonName.value() : ownField.getName();
            mv.visitLdcInsn((Object)((firstWritten ? (char)',' : '{') + "\"" + fieldName + "\":"));
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            firstWritten = true;
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            mv.visitVarInsn(25, 1);
            if (fd.parentField() != null) {
                DelegateGenerator.emitGetField(mv, fd.parentField());
            }
            DelegateGenerator.emitGetField(mv, ownField);
            DelegateGenerator.emitTypeCast(mv, ownField.getType(), sourceClass);
            switch (srcType) {
                case Object: {
                    mv.visitMethodInsn(184, "one/nio/serial/Json", "appendObject", "(Ljava/lang/StringBuilder;Ljava/lang/Object;)V");
                    mv.visitVarInsn(25, 2);
                    continue block4;
                }
                case Char: {
                    mv.visitMethodInsn(184, "one/nio/serial/Json", "appendChar", "(Ljava/lang/StringBuilder;C)V");
                    mv.visitVarInsn(25, 2);
                    continue block4;
                }
                default: {
                    mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", srcType.appendSignature());
                }
            }
        }
        if (!firstWritten) {
            DelegateGenerator.emitInt(mv, 123);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(C)Ljava/lang/StringBuilder;");
        }
        DelegateGenerator.emitInt(mv, 125);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(C)Ljava/lang/StringBuilder;");
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void setDefaultField(MethodVisitor mv, Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            mv.visitFieldInsn(178, "one/nio/util/JavaInternals", "unsafe", "Lsun/misc/Unsafe;");
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn((Object)JavaInternals.unsafe.objectFieldOffset(field));
        } else {
            mv.visitVarInsn(25, 2);
        }
        Default defaultValue = field.getAnnotation(Default.class);
        Class<?> fieldType = field.getType();
        if (!defaultValue.method().isEmpty()) {
            int p;
            String methodName = defaultValue.method();
            Method m = JavaInternals.getMethod(methodName.substring(0, p = methodName.lastIndexOf(46)), methodName.substring(p + 1), new Class[0]);
            if (m == null || !Modifier.isStatic(m.getModifiers()) || !fieldType.isAssignableFrom(m.getReturnType())) {
                throw new IllegalArgumentException("Invalid default initializer " + methodName + " for field " + field);
            }
            DelegateGenerator.emitInvoke(mv, m);
        } else if (!defaultValue.field().isEmpty()) {
            int p;
            String fieldName = defaultValue.field();
            Field f = JavaInternals.getField(fieldName.substring(0, p = fieldName.lastIndexOf(46)), fieldName.substring(p + 1));
            if (f == null || !Modifier.isStatic(f.getModifiers()) || !fieldType.isAssignableFrom(f.getType())) {
                throw new IllegalArgumentException("Invalid default initializer " + fieldName + " for field " + field);
            }
            DelegateGenerator.emitGetField(mv, f);
        } else {
            DelegateGenerator.emitDefaultValue(mv, field, fieldType, defaultValue.value());
        }
        if (Modifier.isFinal(field.getModifiers())) {
            FieldType dstType = FieldType.valueOf(fieldType);
            mv.visitMethodInsn(183, "sun/misc/Unsafe", dstType.putMethod(), dstType.putSignature());
        } else {
            DelegateGenerator.emitPutField(mv, field);
        }
    }

    private static void emitDefaultValue(MethodVisitor mv, Field field, Class<?> fieldType, String value) {
        switch (FieldType.valueOf(fieldType)) {
            case Int: 
            case Byte: 
            case Short: {
                DelegateGenerator.emitInt(mv, Integer.decode(value));
                return;
            }
            case Long: {
                DelegateGenerator.emitLong(mv, Long.decode(value));
                return;
            }
            case Boolean: {
                DelegateGenerator.emitInt(mv, Boolean.parseBoolean(value) ? 1 : 0);
                return;
            }
            case Char: {
                DelegateGenerator.emitInt(mv, value.length() == 1 ? value.charAt(0) : Integer.decode(value).intValue());
                return;
            }
            case Float: {
                DelegateGenerator.emitFloat(mv, Float.parseFloat(value));
                return;
            }
            case Double: {
                DelegateGenerator.emitDouble(mv, Double.parseDouble(value));
                return;
            }
        }
        if (fieldType == String.class) {
            mv.visitLdcInsn((Object)value);
        } else if (fieldType == Character.class) {
            DelegateGenerator.emitInt(mv, value.length() == 1 ? value.charAt(0) : Integer.decode(value).intValue());
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else {
            if (fieldType == Class.class) {
                try {
                    mv.visitLdcInsn(Class.forName(value, false, INSTANCE));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot set default value \"" + value + "\" to " + field, e);
                }
            }
            try {
                Method valueOf = fieldType.getMethod("valueOf", String.class);
                if (!Modifier.isStatic(valueOf.getModifiers()) || valueOf.getReturnType() != fieldType) {
                    throw new NoSuchMethodException("valueOf(String) is not found in class " + fieldType.getName());
                }
                mv.visitLdcInsn((Object)value);
                DelegateGenerator.emitInvoke(mv, valueOf);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Cannot set default value \"" + value + "\" to " + field, e);
            }
        }
    }

    private static void emitTypeCast(MethodVisitor mv, Class<?> src, Class<?> dst) {
        if (src == dst || dst.isAssignableFrom(src)) {
            return;
        }
        if (src.isPrimitive() && dst.isPrimitive()) {
            FieldType srcType = FieldType.valueOf(src);
            FieldType dstType = FieldType.valueOf(dst);
            for (int opcode = srcType.convertTo(dstType); opcode != 0; opcode >>>= 8) {
                mv.visitInsn(opcode & 0xFF);
            }
            return;
        }
        if (src.isArray() && dst.isArray() && src.getComponentType().isPrimitive() == dst.getComponentType().isPrimitive()) {
            String copySig;
            Label isNull = DelegateGenerator.emitNullGuard(mv, dst);
            mv.visitInsn(89);
            mv.visitInsn(190);
            Class<?> dstComponent = dst.getComponentType();
            if (dstComponent.isPrimitive()) {
                mv.visitIntInsn(188, FieldType.valueOf(dstComponent).bytecodeType);
                copySig = "(" + Type.getDescriptor(src) + Type.getDescriptor(dst) + ")V";
            } else {
                mv.visitTypeInsn(189, Type.getInternalName(dstComponent));
                copySig = "([Ljava/lang/Object;[Ljava/lang/Object;)V";
            }
            mv.visitInsn(90);
            mv.visitMethodInsn(184, "one/nio/serial/gen/ArrayCopy", "copy", copySig);
            mv.visitLabel(isNull);
            return;
        }
        if (src.isAssignableFrom(dst)) {
            mv.visitTypeInsn(192, Type.getInternalName(dst));
            return;
        }
        if (src.getSuperclass() == Number.class && dst.getSuperclass() == Number.class) {
            for (Method m : dst.getMethods()) {
                Class<?> param;
                if (m.getParameterTypes().length != 1 || m.getReturnType() != dst || !Modifier.isStatic(m.getModifiers()) || !"valueOf".equals(m.getName()) || !(param = m.getParameterTypes()[0]).isPrimitive() || param == Boolean.TYPE || param == Character.TYPE) continue;
                Label isNull = DelegateGenerator.emitNullGuard(mv, dst);
                String valueMethod = param.getName() + "Value";
                String valueSignature = "()" + Type.getDescriptor(param);
                String valueOfSignature = "(" + Type.getDescriptor(param) + ")" + Type.getDescriptor(dst);
                mv.visitMethodInsn(182, "java/lang/Number", valueMethod, valueSignature);
                mv.visitMethodInsn(184, Type.getInternalName(dst), "valueOf", valueOfSignature);
                mv.visitLabel(isNull);
                return;
            }
        }
        try {
            Method m = dst.getMethod("valueOf", src);
            if (Modifier.isStatic(m.getModifiers()) && m.getReturnType() == dst) {
                DelegateGenerator.emitInvoke(mv, m);
                return;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Method m : src.getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0 || m.getReturnType() != dst) continue;
            Label isNull = DelegateGenerator.emitNullGuard(mv, dst);
            DelegateGenerator.emitInvoke(mv, m);
            mv.visitLabel(isNull);
            return;
        }
        mv.visitInsn(FieldType.valueOf(src).convertTo(FieldType.Void));
        mv.visitInsn(FieldType.Void.convertTo(FieldType.valueOf(dst)));
    }

    private static Label emitNullGuard(MethodVisitor mv, Class<?> dst) {
        Label isNull = new Label();
        Label nonNull = new Label();
        mv.visitInsn(89);
        mv.visitJumpInsn(199, nonNull);
        mv.visitInsn(87);
        mv.visitInsn(FieldType.Void.convertTo(FieldType.valueOf(dst)));
        mv.visitJumpInsn(167, isNull);
        mv.visitLabel(nonNull);
        return isNull;
    }
}

