/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial.gen;

import java.util.concurrent.atomic.AtomicInteger;
import one.nio.gen.BytecodeGenerator;
import one.nio.serial.FieldDescriptor;
import one.nio.serial.Repository;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class StubGenerator
extends BytecodeGenerator {
    public static final AtomicInteger stubClasses = new AtomicInteger();

    public static Class generateRegular(String className, String superName, FieldDescriptor[] fds) {
        String internalClassName = StubGenerator.getStubName(className);
        ClassWriter cv = new ClassWriter(3);
        cv.visit(50, 17, internalClassName, null, superName, new String[]{"java/io/Serializable"});
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superName, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        if (fds != null) {
            for (FieldDescriptor fd : fds) {
                String name = fd.name();
                String oldName = null;
                int p = name.indexOf(124);
                if (p >= 0) {
                    oldName = name.substring(p + 1);
                    name = name.substring(0, p);
                }
                FieldVisitor fv = cv.visitField(2, name, Type.getDescriptor((Class)fd.type().resolve()), null, null);
                if (oldName != null) {
                    AnnotationVisitor av = fv.visitAnnotation("Lone/nio/serial/Renamed;", true);
                    av.visit("from", (Object)oldName);
                    av.visitEnd();
                }
                fv.visitEnd();
            }
        }
        cv.visitEnd();
        return INSTANCE.defineClassIfNotExists(internalClassName.replace('/', '.'), cv.toByteArray());
    }

    public static Class generateEnum(String className, String[] constants) {
        String internalClassName = StubGenerator.getStubName(className);
        ClassWriter cv = new ClassWriter(3);
        cv.visit(50, 16401, internalClassName, null, "java/lang/Enum", null);
        String classDesc = 'L' + internalClassName + ';';
        for (String c : constants) {
            cv.visitField(25, c, classDesc, null, null).visitEnd();
        }
        String arrayDesc = '[' + classDesc;
        cv.visitField(26, "$VALUES", arrayDesc, null, null).visitEnd();
        MethodVisitor mv = cv.visitMethod(2, "<init>", "(Ljava/lang/String;I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, "java/lang/Enum", "<init>", "(Ljava/lang/String;I)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cv.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        StubGenerator.emitInt(mv, constants.length);
        mv.visitTypeInsn(189, internalClassName);
        for (int i = 0; i < constants.length; ++i) {
            mv.visitInsn(89);
            StubGenerator.emitInt(mv, i);
            mv.visitTypeInsn(187, internalClassName);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)constants[i]);
            StubGenerator.emitInt(mv, i);
            mv.visitMethodInsn(183, internalClassName, "<init>", "(Ljava/lang/String;I)V");
            mv.visitInsn(89);
            mv.visitFieldInsn(179, internalClassName, constants[i], classDesc);
            mv.visitInsn(83);
        }
        mv.visitFieldInsn(179, internalClassName, "$VALUES", arrayDesc);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cv.visitMethod(9, "values", "()" + arrayDesc, null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, internalClassName, "$VALUES", arrayDesc);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cv.visitMethod(9, "valueOf", "(Ljava/lang/String;)" + classDesc, null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)Type.getObjectType((String)internalClassName));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
        mv.visitTypeInsn(192, internalClassName);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cv.visitEnd();
        return INSTANCE.defineClassIfNotExists(internalClassName.replace('/', '.'), cv.toByteArray());
    }

    private static String getStubName(String className) {
        Repository.log.warn((Object)("Generating stub for class " + className));
        stubClasses.incrementAndGet();
        return "sun/reflect/" + className;
    }
}

