/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import java.io.IOException;
import java.util.Iterator;
import one.nio.net.Selector;
import one.nio.net.Session;
import one.nio.os.Proc;

public final class SelectorThread
extends Thread {
    private static final int BUFFER_SIZE = 64000;
    public final Selector selector = Selector.create();
    public final long affinity;
    long operations;
    long sessions;
    int maxReady;

    public SelectorThread(int num, long affinity) throws IOException {
        super("NIO Selector #" + num);
        this.affinity = affinity;
    }

    public void shutdown() {
        this.selector.close();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        if (this.affinity != 0L && Proc.IS_SUPPORTED) {
            Proc.sched_setaffinity(0, this.affinity);
        }
        byte[] buffer = new byte[64000];
        while (this.selector.isOpen()) {
            int ready = 0;
            Iterator<Session> selectedSessions = this.selector.select();
            while (selectedSessions.hasNext()) {
                Session session = selectedSessions.next();
                try {
                    session.process(buffer);
                }
                catch (Throwable e) {
                    session.handleException(e);
                }
                ++ready;
            }
            ++this.operations;
            this.sessions += (long)ready;
            if (ready <= this.maxReady) continue;
            this.maxReady = ready;
        }
    }
}

