/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http.gen;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import one.nio.gen.BytecodeGenerator;
import one.nio.http.Header;
import one.nio.http.HttpSession;
import one.nio.http.Param;
import one.nio.http.Request;
import one.nio.http.RequestHandler;
import one.nio.http.Response;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class RequestHandlerGenerator
extends BytecodeGenerator {
    private int count;

    public RequestHandler generateFor(Method m, Object router) {
        if (Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("Method should not be static: " + m);
        }
        Class<?> returnType = m.getReturnType();
        if (returnType != Void.TYPE && returnType != Response.class) {
            throw new IllegalArgumentException("Invalid return type of " + m);
        }
        String className = "RequestHandler" + this.count++ + "_" + m.getName();
        String routerType = Type.getDescriptor(m.getDeclaringClass());
        ClassWriter cv = new ClassWriter(3);
        cv.visit(50, 17, className, null, "java/lang/Object", new String[]{"one/nio/http/RequestHandler"});
        cv.visitField(18, "router", routerType, null, null).visitEnd();
        MethodVisitor mv = cv.visitMethod(1, "<init>", "(" + routerType + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, className, "router", routerType);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cv.visitMethod(17, "handleRequest", "(Lone/nio/http/Request;Lone/nio/http/HttpSession;)V", null, null);
        mv.visitCode();
        if (m.getReturnType() == Response.class) {
            mv.visitVarInsn(25, 2);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "router", routerType);
        this.setupArguments(mv, m);
        RequestHandlerGenerator.emitInvoke(mv, m);
        if (m.getReturnType() == Response.class) {
            mv.visitMethodInsn(182, "one/nio/http/HttpSession", "sendResponse", "(Lone/nio/http/Response;)V");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cv.visitEnd();
        return this.instantiate(cv.toByteArray(), m, router);
    }

    private void setupArguments(MethodVisitor mv, Method m) {
        Class<?>[] types = m.getParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        block0: for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            if (type == Request.class) {
                mv.visitVarInsn(25, 1);
                continue;
            }
            if (type == HttpSession.class) {
                mv.visitVarInsn(25, 2);
                continue;
            }
            for (Annotation annotation : annotations[i]) {
                if (annotation instanceof Param) {
                    this.setupParam(mv, type, (Param)annotation);
                    continue block0;
                }
                if (!(annotation instanceof Header)) continue;
                this.setupHeader(mv, type, (Header)annotation);
                continue block0;
            }
            throw new IllegalArgumentException("Missing @Param or @Header for argument " + i + " of " + m);
        }
    }

    private void setupParam(MethodVisitor mv, Class type, Param param) {
        String name = param.value();
        String defaultValue = null;
        int eq = name.indexOf(61);
        if (eq > 0) {
            defaultValue = name.substring(eq + 1);
            name = name.substring(0, eq);
        }
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)(name + '='));
        boolean needNullCheck = false;
        if (param.required()) {
            mv.visitMethodInsn(182, "one/nio/http/Request", "getRequiredParameter", "(Ljava/lang/String;)Ljava/lang/String;");
        } else if (defaultValue != null) {
            mv.visitLdcInsn((Object)defaultValue);
            mv.visitMethodInsn(182, "one/nio/http/Request", "getParameter", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        } else {
            mv.visitMethodInsn(182, "one/nio/http/Request", "getParameter", "(Ljava/lang/String;)Ljava/lang/String;");
            needNullCheck = true;
        }
        this.convertArgument(mv, type, needNullCheck);
    }

    private void setupHeader(MethodVisitor mv, Class type, Header header) {
        String name = header.value();
        String defaultValue = null;
        int eq = name.indexOf(61);
        if (eq > 0) {
            defaultValue = name.substring(eq + 1);
            name = name.substring(0, eq);
        }
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)(name + ": "));
        boolean needNullCheck = false;
        if (header.required()) {
            mv.visitMethodInsn(182, "one/nio/http/Request", "getRequiredHeader", "(Ljava/lang/String;)Ljava/lang/String;");
        } else if (defaultValue != null) {
            mv.visitLdcInsn((Object)defaultValue);
            mv.visitMethodInsn(182, "one/nio/http/Request", "getHeader", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        } else {
            mv.visitMethodInsn(182, "one/nio/http/Request", "getHeader", "(Ljava/lang/String;)Ljava/lang/String;");
            needNullCheck = true;
        }
        this.convertArgument(mv, type, needNullCheck);
    }

    private void convertArgument(MethodVisitor mv, Class type, boolean needNullCheck) {
        if (type == String.class) {
            return;
        }
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                mv.visitMethodInsn(184, "java/lang/Integer", "parseInt", "(Ljava/lang/String;)I");
            } else if (type == Long.TYPE) {
                mv.visitMethodInsn(184, "java/lang/Long", "parseLong", "(Ljava/lang/String;)J");
            } else if (type == Byte.TYPE) {
                mv.visitMethodInsn(184, "java/lang/Byte", "parseByte", "(Ljava/lang/String;)B");
            } else if (type == Short.TYPE) {
                mv.visitMethodInsn(184, "java/lang/Short", "parseShort", "(Ljava/lang/String;)S");
            } else if (type == Float.TYPE) {
                mv.visitMethodInsn(184, "java/lang/Float", "parseFloat", "(Ljava/lang/String;)F");
            } else if (type == Double.TYPE) {
                mv.visitMethodInsn(184, "java/lang/Double", "parseDouble", "(Ljava/lang/String;)D");
            } else if (type == Boolean.TYPE) {
                mv.visitMethodInsn(184, "java/lang/Boolean", "parseBoolean", "(Ljava/lang/String;)Z");
            } else if (type == Character.TYPE) {
                mv.visitInsn(3);
                mv.visitMethodInsn(182, "java/lang/String", "charAt", "(I)C");
            }
            return;
        }
        Label isNull = new Label();
        if (needNullCheck) {
            Label nonNull = new Label();
            mv.visitInsn(89);
            mv.visitJumpInsn(199, nonNull);
            mv.visitInsn(87);
            mv.visitInsn(1);
            mv.visitJumpInsn(167, isNull);
            mv.visitLabel(nonNull);
        }
        if (type == Integer.class) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(Ljava/lang/String;)Ljava/lang/Integer;");
        } else if (type == Long.class) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(Ljava/lang/String;)Ljava/lang/Long;");
        } else if (type == Byte.class) {
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(Ljava/lang/String;)Ljava/lang/Byte;");
        } else if (type == Short.class) {
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(Ljava/lang/String;)Ljava/lang/Short;");
        } else if (type == Float.class) {
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(Ljava/lang/String;)Ljava/lang/Float;");
        } else if (type == Double.class) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(Ljava/lang/String;)Ljava/lang/Double;");
        } else if (type == Boolean.class) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Ljava/lang/String;)Ljava/lang/Boolean;");
        } else {
            throw new IllegalArgumentException("Unsupported argument type: " + type.getName());
        }
        if (needNullCheck) {
            mv.visitLabel(isNull);
        }
    }

    private RequestHandler instantiate(byte[] classData, Method m, Object router) {
        try {
            Class<?> resultClass = super.defineClass(classData);
            Constructor<?> c = resultClass.getConstructor(m.getDeclaringClass());
            return (RequestHandler)c.newInstance(router);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot generate valid RequestHandler for " + m, e);
        }
    }
}

