/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mgt;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadDumper {
    private static final AtomicLong dumpTime = new AtomicLong();
    private static Method dumpMethod;

    private static Method getDumpMethod() throws IOException, ClassNotFoundException, NoSuchMethodException {
        File javaHome = new File(System.getProperty("java.home"));
        String toolsPath = javaHome.getName().equalsIgnoreCase("jre") ? "../lib/tools.jar" : "lib/tools.jar";
        URL[] urls = new URL[]{ThreadDumper.class.getProtectionDomain().getCodeSource().getLocation(), new File(javaHome, toolsPath).getCanonicalFile().toURI().toURL()};
        URLClassLoader loader = new URLClassLoader(urls, null);
        return loader.loadClass("one.nio.mgt.ThreadDumperImpl").getMethod("dump", OutputStream.class);
    }

    public static synchronized void dump(OutputStream out) throws IOException {
        try {
            if (dumpMethod == null) {
                dumpMethod = ThreadDumper.getDumpMethod();
            }
            dumpMethod.invoke(null, out);
        }
        catch (IOException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            throw target instanceof IOException ? (IOException)target : new IOException(target);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void dump(OutputStream out, long minDumpInterval) throws IOException {
        long lastDumpTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastDumpTime = dumpTime.get()) >= minDumpInterval && dumpTime.compareAndSet(lastDumpTime, currentTime)) {
            ThreadDumper.dump(out);
        }
    }
}

