/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mgt;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import sun.tools.attach.HotSpotVirtualMachine;

public class ThreadDumperImpl {
    private static final String PID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(OutputStream out) throws IOException {
        block18: {
            HotSpotVirtualMachine vm;
            try {
                vm = (HotSpotVirtualMachine)VirtualMachine.attach(PID);
            }
            catch (AttachNotSupportedException e) {
                throw new IOException(e);
            }
            try {
                if (out == null) {
                    vm.localDataDump();
                    break block18;
                }
                try (InputStream in = vm.remoteDataDump(new Object[0]);){
                    ThreadDumperImpl.copy(in, out);
                }
            }
            finally {
                vm.detach();
            }
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int bytes;
        byte[] buf = new byte[8192];
        while ((bytes = in.read(buf)) > 0) {
            out.write(buf, 0, bytes);
        }
        out.flush();
    }

    static {
        String vmName = ManagementFactory.getRuntimeMXBean().getName();
        PID = vmName.substring(0, vmName.indexOf(64));
    }
}

