/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionString {
    private static final Pattern INTERFACE_PATTERN = Pattern.compile("\\{(.+)\\}");
    protected String protocol;
    protected String host;
    protected int port;
    protected String path;
    protected Map<String, String> params;

    protected ConnectionString() {
    }

    public ConnectionString(String connectionString) {
        this(connectionString, true);
    }

    public ConnectionString(String connectionString, boolean expand) {
        int addrStart;
        int queryString;
        int p;
        if (expand) {
            connectionString = ConnectionString.expand(connectionString);
        }
        if ((p = connectionString.indexOf("//")) > 1) {
            this.protocol = connectionString.substring(0, p - 1);
        }
        if ((queryString = connectionString.indexOf(63, addrStart = p >= 0 ? p + 2 : 0)) >= 0) {
            this.params = ConnectionString.parseParameters(connectionString.substring(queryString + 1));
        } else {
            queryString = connectionString.length();
            this.params = Collections.emptyMap();
        }
        p = connectionString.indexOf(47, addrStart);
        int addrEnd = p >= 0 && p < queryString ? p : queryString;
        p = connectionString.lastIndexOf(58, addrEnd);
        if (p >= addrStart && p < addrEnd) {
            this.host = connectionString.substring(addrStart, p);
            this.port = Integer.parseInt(connectionString.substring(p + 1, addrEnd));
        } else {
            this.host = connectionString.substring(addrStart, addrEnd);
            this.port = 0;
        }
        this.path = connectionString.substring(addrEnd);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getStringParam(String key) {
        return this.params.get(key);
    }

    public String getStringParam(String key, String defaultValue) {
        String result = this.params.get(key);
        return result != null ? result : defaultValue;
    }

    public int getIntParam(String key, int defaultValue) {
        String result = this.params.get(key);
        return result != null ? Integer.parseInt(result) : defaultValue;
    }

    public long getLongParam(String key, long defaultValue) {
        String result = this.params.get(key);
        return result != null ? Long.parseLong(result) : defaultValue;
    }

    public boolean getBooleanParam(String key, boolean defaultValue) {
        String result = this.params.get(key);
        return result != null ? result.equalsIgnoreCase("true") : defaultValue;
    }

    public static String expand(String url) {
        Matcher matcher = INTERFACE_PATTERN.matcher(url);
        if (!matcher.find()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url.length() + 32);
        int lastPosition = 0;
        do {
            String interfaceAddress;
            String interfaceName;
            if ((interfaceName = matcher.group(1)).startsWith("auto:")) {
                interfaceAddress = ConnectionString.getRoutingAddress(interfaceName.substring(5));
            } else {
                interfaceAddress = ConnectionString.getAddressFromProperty(interfaceName);
                if (interfaceAddress == null) {
                    interfaceAddress = ConnectionString.getInterfaceAddress(interfaceName);
                }
            }
            if (interfaceAddress != null) {
                sb.append(url, lastPosition, matcher.start()).append(interfaceAddress);
                continue;
            }
            sb.append(url, lastPosition, matcher.end());
        } while (matcher.find(lastPosition = matcher.end()));
        return sb.append(url, lastPosition, url.length()).toString();
    }

    public static String getAddressFromProperty(String interfaceName) {
        String address = System.getProperty(interfaceName, System.getenv(interfaceName));
        if (address == null) {
            return null;
        }
        try {
            return InetAddress.getByName(address).getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRoutingAddress(String targetIP) {
        try (DatagramChannel ch = DatagramChannel.open();){
            ch.connect(new InetSocketAddress(targetIP, 7));
            String string = ch.socket().getLocalAddress().getHostAddress();
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getInterfaceAddress(String interfaceName) {
        try {
            NetworkInterface intf = NetworkInterface.getByName(interfaceName);
            if (intf == null) {
                return null;
            }
            Enumeration<InetAddress> addrs = intf.getInetAddresses();
            if (!addrs.hasMoreElements()) {
                return null;
            }
            InetAddress result = addrs.nextElement();
            while (!(result instanceof Inet4Address) && addrs.hasMoreElements()) {
                result = addrs.nextElement();
            }
            return result.getHostAddress();
        }
        catch (SocketException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Map<String, String> parseParameters(String parameters) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(parameters, "&");
        while (tokenizer.hasMoreTokens()) {
            String param = tokenizer.nextToken();
            int p = param.indexOf(61);
            if (p <= 0) continue;
            result.put(param.substring(0, p), param.substring(p + 1));
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.protocol != null) {
            sb.append(this.protocol).append("://");
        }
        sb.append(this.host);
        if (this.port != 0) {
            sb.append(':').append(this.port);
        }
        if (this.path != null) {
            sb.append(this.path);
        }
        return sb.toString();
    }
}

