/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import one.nio.mem.DirectMemory;
import one.nio.net.NativeSslContext;
import one.nio.net.NativeSslSocket;
import one.nio.net.Socket;
import one.nio.net.SslContext;
import one.nio.os.Mem;

class NativeSocket
extends Socket {
    private static final int SOCKADDR_SIZE = 25;
    int fd;

    NativeSocket(boolean datagram) throws IOException {
        this.fd = NativeSocket.socket0(datagram);
    }

    NativeSocket(int fd) {
        this.fd = fd;
    }

    @Override
    public final boolean isOpen() {
        return this.fd >= 0;
    }

    @Override
    public NativeSocket accept() throws IOException {
        return new NativeSocket(this.accept0(false));
    }

    @Override
    public Socket acceptNonBlocking() throws IOException {
        return new NativeSocket(this.accept0(true));
    }

    @Override
    public final InetSocketAddress getLocalAddress() {
        byte[] sockaddr = new byte[25];
        this.getsockname(sockaddr);
        return this.makeAddress(sockaddr);
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        byte[] sockaddr = new byte[25];
        this.getpeername(sockaddr);
        return this.makeAddress(sockaddr);
    }

    private InetSocketAddress makeAddress(byte[] buffer) {
        byte[] address;
        if (buffer[0] == 8) {
            address = Arrays.copyOfRange(buffer, 5, 9);
        } else if (buffer[0] == 24) {
            address = Arrays.copyOfRange(buffer, 9, 25);
        } else {
            return null;
        }
        int port = (buffer[3] & 0xFF) << 8 | buffer[4] & 0xFF;
        try {
            return new InetSocketAddress(InetAddress.getByAddress(address), port);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public Socket sslWrap(SslContext context) throws IOException {
        return new NativeSslSocket(this.fd, (NativeSslContext)context, false);
    }

    @Override
    public Socket sslUnwrap() {
        return this;
    }

    @Override
    public SslContext getSslContext() {
        return null;
    }

    @Override
    public final void connect(InetAddress address, int port) throws IOException {
        this.connect0(address.getAddress(), port);
    }

    @Override
    public final void bind(InetAddress address, int port, int backlog) throws IOException {
        this.bind0(address.getAddress(), port);
    }

    @Override
    public final native void listen(int var1) throws IOException;

    @Override
    public native void close();

    @Override
    public native int writeRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public int send(ByteBuffer data, int flags, InetAddress address, int port) throws IOException {
        if (!data.isDirect()) {
            throw new UnsupportedOperationException();
        }
        long bufAddress = DirectMemory.getAddress(data) + (long)data.position();
        int result = this.sendTo(bufAddress, data.remaining(), flags, address.getAddress(), port);
        if (result > 0) {
            data.position(data.position() + result);
        }
        return result;
    }

    @Override
    public native int write(byte[] var1, int var2, int var3, int var4) throws IOException;

    @Override
    public native void writeFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public native int readRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public native int read(byte[] var1, int var2, int var3, int var4) throws IOException;

    @Override
    public InetSocketAddress recv(ByteBuffer buffer, int flags) throws IOException {
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException();
        }
        byte[] sockaddr = new byte[25];
        long bufAddress = DirectMemory.getAddress(buffer) + (long)buffer.position();
        int result = this.recvFrom(bufAddress, buffer.remaining(), flags, sockaddr);
        if (result <= 0) {
            return null;
        }
        buffer.position(buffer.position() + result);
        return this.makeAddress(sockaddr);
    }

    @Override
    public native void readFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public long sendFile(RandomAccessFile file, long offset, long count) throws IOException {
        return this.sendFile0(Mem.getFD(file.getFD()), offset, count);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytes = dst.hasArray() ? this.read(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining(), 0) : this.readRaw(DirectMemory.getAddress(dst) + (long)dst.position(), dst.remaining(), 0);
        dst.position(dst.position() + bytes);
        return bytes;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int bytes = src.hasArray() ? this.write(src.array(), src.arrayOffset() + src.position(), src.remaining(), 0) : this.writeRaw(DirectMemory.getAddress(src) + (long)src.position(), src.remaining(), 0);
        src.position(src.position() + bytes);
        return bytes;
    }

    @Override
    public final native void setBlocking(boolean var1);

    @Override
    public final native void setTimeout(int var1);

    @Override
    public final native void setKeepAlive(boolean var1);

    @Override
    public final native void setNoDelay(boolean var1);

    @Override
    public final native void setTcpFastOpen(boolean var1);

    @Override
    public final native void setDeferAccept(boolean var1);

    @Override
    public final native void setReuseAddr(boolean var1, boolean var2);

    @Override
    public final native void setRecvBuffer(int var1);

    @Override
    public final native void setSendBuffer(int var1);

    @Override
    public final native void setTos(int var1);

    @Override
    public native byte[] getOption(int var1, int var2);

    @Override
    public native boolean setOption(int var1, int var2, byte[] var3);

    static native int socket0(boolean var0) throws IOException;

    native void connect0(byte[] var1, int var2) throws IOException;

    native void bind0(byte[] var1, int var2) throws IOException;

    static native int socket1() throws IOException;

    native void connect1(String var1) throws IOException;

    native void bind1(String var1) throws IOException;

    native int accept0(boolean var1) throws IOException;

    native long sendFile0(int var1, long var2, long var4) throws IOException;

    native void getsockname(byte[] var1);

    native void getpeername(byte[] var1);

    native int sendTo(long var1, int var3, int var4, byte[] var5, int var6) throws IOException;

    native int recvFrom(long var1, int var3, int var4, byte[] var5) throws IOException;
}

