/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.io.RandomAccessFile;
import one.nio.net.NativeSocket;
import one.nio.net.NativeSslContext;
import one.nio.net.Socket;
import one.nio.net.SslContext;

class NativeSslSocket
extends NativeSocket {
    NativeSslContext context;
    long ssl;

    NativeSslSocket(int fd, NativeSslContext context, boolean serverMode) throws IOException {
        super(fd);
        context.refresh();
        this.context = context;
        this.ssl = NativeSslSocket.sslNew(fd, context.ctx, serverMode);
    }

    @Override
    public synchronized void close() {
        if (this.ssl != 0L) {
            NativeSslSocket.sslFree(this.ssl);
            this.ssl = 0L;
        }
        super.close();
    }

    @Override
    public NativeSocket accept() throws IOException {
        return new NativeSslSocket(this.accept0(false), this.context, true);
    }

    @Override
    public Socket acceptNonBlocking() throws IOException {
        return new NativeSslSocket(this.accept0(true), this.context, true);
    }

    @Override
    public Socket sslUnwrap() {
        return new NativeSocket(this.fd);
    }

    @Override
    public SslContext getSslContext() {
        return this.context;
    }

    @Override
    public byte[] getOption(int level, int option) {
        if (level == 1024) {
            return this.sslGetOption(option);
        }
        return super.getOption(level, option);
    }

    @Override
    public long sendFile(RandomAccessFile file, long offset, long count) throws IOException {
        throw new IOException("Cannot use sendFile with SSL");
    }

    @Override
    public synchronized native int writeRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public synchronized native int write(byte[] var1, int var2, int var3, int var4) throws IOException;

    @Override
    public synchronized native void writeFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public synchronized native int readRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public synchronized native int read(byte[] var1, int var2, int var3, int var4) throws IOException;

    @Override
    public synchronized native void readFully(byte[] var1, int var2, int var3) throws IOException;

    private synchronized native byte[] sslGetOption(int var1);

    static native long sslNew(int var0, long var1, boolean var3) throws IOException;

    static native void sslFree(long var0);
}

