/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import one.nio.net.JavaDatagramSocket;
import one.nio.net.JavaServerSocket;
import one.nio.net.JavaSocket;
import one.nio.net.NativeSocket;
import one.nio.net.SslContext;
import one.nio.os.NativeLibrary;

public abstract class Socket
implements ByteChannel {
    public static final int SOL_SOCKET = 1;
    public static final int SOL_IP = 0;
    public static final int SOL_IPV6 = 41;
    public static final int SOL_TCP = 6;
    public static final int SOL_UDP = 17;
    public static final int SOL_SSL = 1024;
    public static final int SSL_SESSION = 1;
    public static final int SSL_SESSION_REUSED = 2;
    public static final int SSL_SESSION_TICKET = 3;
    public static final int MSG_OOB = 1;
    public static final int MSG_PEEK = 2;
    public static final int MSG_DONTROUTE = 4;
    public static final int MSG_TRUNC = 32;
    public static final int MSG_DONTWAIT = 64;
    public static final int MSG_WAITALL = 256;
    public static final int MSG_MORE = 32768;
    public static final int IPTOS_MINCOST = 2;
    public static final int IPTOS_RELIABILITY = 4;
    public static final int IPTOS_THROUGHPUT = 8;
    public static final int IPTOS_LOWDELAY = 16;

    @Override
    public abstract boolean isOpen();

    @Override
    public abstract void close();

    public abstract Socket accept() throws IOException;

    public abstract void connect(InetAddress var1, int var2) throws IOException;

    public abstract void bind(InetAddress var1, int var2, int var3) throws IOException;

    public abstract void listen(int var1) throws IOException;

    public abstract int writeRaw(long var1, int var3, int var4) throws IOException;

    public abstract int write(byte[] var1, int var2, int var3, int var4) throws IOException;

    public abstract void writeFully(byte[] var1, int var2, int var3) throws IOException;

    public abstract int send(ByteBuffer var1, int var2, InetAddress var3, int var4) throws IOException;

    public abstract int readRaw(long var1, int var3, int var4) throws IOException;

    public abstract int read(byte[] var1, int var2, int var3, int var4) throws IOException;

    public abstract void readFully(byte[] var1, int var2, int var3) throws IOException;

    public abstract InetSocketAddress recv(ByteBuffer var1, int var2) throws IOException;

    public abstract long sendFile(RandomAccessFile var1, long var2, long var4) throws IOException;

    public abstract void setBlocking(boolean var1);

    public abstract void setTimeout(int var1);

    public abstract void setKeepAlive(boolean var1);

    public abstract void setNoDelay(boolean var1);

    public abstract void setTcpFastOpen(boolean var1);

    public abstract void setDeferAccept(boolean var1);

    public abstract void setReuseAddr(boolean var1, boolean var2);

    public abstract void setRecvBuffer(int var1);

    public abstract void setSendBuffer(int var1);

    public abstract void setTos(int var1);

    public abstract byte[] getOption(int var1, int var2);

    public abstract boolean setOption(int var1, int var2, byte[] var3);

    public abstract InetSocketAddress getLocalAddress();

    public abstract InetSocketAddress getRemoteAddress();

    public abstract Socket sslWrap(SslContext var1) throws IOException;

    public abstract Socket sslUnwrap();

    public abstract SslContext getSslContext();

    public Socket acceptNonBlocking() throws IOException {
        Socket s = this.accept();
        s.setBlocking(false);
        return s;
    }

    public void connect(String host, int port) throws IOException {
        this.connect(InetAddress.getByName(host), port);
    }

    public void bind(String host, int port, int backlog) throws IOException {
        this.bind(InetAddress.getByName(host), port, backlog);
    }

    public int write(byte[] data, int offset, int count) throws IOException {
        return this.write(data, offset, count, 0);
    }

    public int read(byte[] data, int offset, int count) throws IOException {
        return this.read(data, offset, count, 0);
    }

    public static Socket create() throws IOException {
        return NativeLibrary.IS_SUPPORTED ? new NativeSocket(false) : new JavaSocket();
    }

    public static Socket createServerSocket() throws IOException {
        return NativeLibrary.IS_SUPPORTED ? new NativeSocket(false) : new JavaServerSocket();
    }

    public static Socket createDatagramSocket() throws IOException {
        return NativeLibrary.IS_SUPPORTED ? new NativeSocket(true) : new JavaDatagramSocket();
    }

    public static Socket connectInet(InetAddress address, int port) throws IOException {
        Socket sock = Socket.create();
        sock.connect(address, port);
        return sock;
    }

    public static Socket bindInet(InetAddress address, int port, int backlog) throws IOException {
        Socket sock = Socket.createServerSocket();
        sock.bind(address, port, backlog);
        sock.listen(backlog);
        return sock;
    }

    public static Socket connectUnix(File unixPath) throws IOException {
        if (!NativeLibrary.IS_SUPPORTED) {
            throw new IOException("Unix sockets are supported in native mode only");
        }
        NativeSocket sock = new NativeSocket(NativeSocket.socket1());
        sock.connect1(unixPath.getAbsolutePath());
        return sock;
    }

    public static Socket bindUnix(File unixPath, int backlog) throws IOException {
        if (!NativeLibrary.IS_SUPPORTED) {
            throw new IOException("Unix sockets are supported in native mode only");
        }
        NativeSocket sock = new NativeSocket(NativeSocket.socket1());
        sock.bind1(unixPath.getAbsolutePath());
        sock.listen(backlog);
        return sock;
    }

    public static Socket fromFD(int fd) throws IOException {
        if (NativeLibrary.IS_SUPPORTED) {
            return new NativeSocket(fd);
        }
        throw new IOException("Operation is not supported");
    }
}

