/*
 * Decompiled with CFR 0.152.
 */
package one.nio.rpc;

import java.io.IOException;
import one.nio.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RpcPacket {
    private static final Log log = LogFactory.getLog(RpcPacket.class);
    private static final int WARN_PACKET_SIZE = 0x400000;
    private static final int ERROR_PACKET_SIZE = 0x8000000;
    static final int STREAM_HEADER = -307308029;
    static final byte[] STREAM_HEADER_ARRAY = new byte[]{-19, -82, -38, 3};
    static final int HTTP_GET = 1195725856;
    static final int HTTP_POST = 1347375956;
    static final int HTTP_HEAD = 1212498244;

    RpcPacket() {
    }

    static boolean isHttpHeader(int header) {
        return header == 1195725856 || header == 1347375956 || header == 1212498244;
    }

    static int getSize(byte[] buffer) {
        return buffer[0] << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
    }

    static void checkSize(int size, Socket socket) throws IOException {
        if (size <= 0 || size >= 0x8000000) {
            throw new IOException("Invalid RPC packet from " + socket.getRemoteAddress());
        }
        if (size >= 0x400000) {
            log.warn((Object)("RPC packet from " + socket.getRemoteAddress() + " is too large: " + size));
        }
    }
}

