/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import one.nio.mem.DirectMemory;
import one.nio.serial.DataStream;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.util.JavaInternals;

public class ObjectInputChannel
extends DataStream {
    private static final int INITIAL_CAPACITY = 16;
    private final ReadableByteChannel ch;
    private int capacity;
    private Object[] context;
    private int contextSize;
    private long bytesRead;

    public ObjectInputChannel(ReadableByteChannel ch) {
        this(ch, 32768);
    }

    public ObjectInputChannel(ReadableByteChannel ch, int bufSize) {
        super(JavaInternals.unsafe.allocateMemory(bufSize), 0L);
        this.ch = ch;
        this.capacity = bufSize;
        this.context = new Object[16];
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        Serializer serializer;
        byte b = this.readByte();
        if (b >= 0) {
            --this.offset;
            serializer = Repository.requestSerializer(this.readLong());
        } else {
            switch (b) {
                case -1: {
                    return null;
                }
                case -2: {
                    return this.context[this.readUnsignedShort() + 1];
                }
                case -3: {
                    return this.context[this.readInt() + 1];
                }
                case -4: {
                    serializer = (Serializer)this.readObject();
                    Repository.provideSerializer(serializer);
                    break;
                }
                default: {
                    serializer = Repository.requestBootstrapSerializer(b);
                }
            }
        }
        if (++this.contextSize >= this.context.length) {
            this.context = Arrays.copyOf(this.context, this.context.length * 2);
        }
        return serializer.read(this);
    }

    public void reset() {
        if (this.context.length > 16) {
            this.context = new Object[16];
        } else {
            Arrays.fill(this.context, null);
        }
        this.contextSize = 0;
    }

    @Override
    public void close() throws IOException {
        JavaInternals.unsafe.freeMemory(this.address);
        this.address = 0L;
    }

    @Override
    public void register(Object obj) {
        this.context[this.contextSize] = obj;
    }

    @Override
    protected long alloc(int size) throws IOException {
        int available = (int)(this.limit - this.offset);
        if (available < size) {
            this.fetch(size - available);
        }
        long currentOffset = this.offset;
        this.offset = currentOffset + (long)size;
        return currentOffset;
    }

    private void fetch(int size) throws IOException {
        int available = (int)(this.limit - this.offset);
        if (available + size > this.capacity) {
            int newBufSize = Math.max(available + size + 32768, this.capacity * 3 / 2);
            long newAddress = JavaInternals.unsafe.allocateMemory(newBufSize);
            if (available > 0) {
                JavaInternals.unsafe.copyMemory(null, this.offset, null, newAddress, available);
            }
            JavaInternals.unsafe.freeMemory(this.address);
            this.address = newAddress;
            this.offset = newAddress;
            this.limit = newAddress + (long)available;
            this.capacity = newBufSize;
        } else {
            if (available > 0) {
                JavaInternals.unsafe.copyMemory(null, this.offset, null, this.address, available);
            }
            this.offset = this.address;
            this.limit = this.address + (long)available;
        }
        ByteBuffer bb = DirectMemory.wrap(this.limit, this.capacity - available);
        while (size > 0) {
            int bytes = this.ch.read(bb);
            if (bytes < 0) {
                throw new EOFException();
            }
            this.limit += (long)bytes;
            size -= bytes;
            this.bytesRead += (long)bytes;
        }
    }
}

