/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import one.nio.mem.DirectMemory;
import one.nio.serial.DataStream;
import one.nio.serial.Repository;
import one.nio.serial.SerializationContext;
import one.nio.serial.Serializer;
import one.nio.util.JavaInternals;

public class ObjectOutputChannel
extends DataStream {
    private final WritableByteChannel ch;
    private final SerializationContext context;
    private long[] serializerSet;
    private int serializerSetSize;
    private long bytesWritten;

    public ObjectOutputChannel(WritableByteChannel ch) {
        this(ch, 32768);
    }

    public ObjectOutputChannel(WritableByteChannel ch, int bufSize) {
        super(JavaInternals.unsafe.allocateMemory(bufSize), bufSize);
        this.ch = ch;
        this.context = new SerializationContext();
        this.serializerSet = new long[16];
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeByte(-1);
        } else {
            int index = this.context.indexOf(obj);
            if (index < 0) {
                Serializer<?> serializer = Repository.get(obj.getClass());
                if (serializer.uid < 0L) {
                    this.writeByte((byte)serializer.uid);
                } else if (this.addSerializer(serializer.uid)) {
                    this.writeByte(-4);
                    this.writeObject(serializer);
                } else {
                    this.writeLong(serializer.uid);
                }
                this.context.put(obj);
                serializer.write(obj, this);
            } else if (index <= 65535) {
                this.writeByte(-2);
                this.writeShort(index);
            } else {
                this.writeByte(-3);
                this.writeInt(index);
            }
        }
    }

    public void reset() {
        this.context.clear();
    }

    @Override
    public void flush() throws IOException {
        int count = this.count();
        if (count > 0) {
            ByteBuffer bb = DirectMemory.wrap(this.address, count);
            do {
                this.ch.write(bb);
            } while (bb.hasRemaining());
            this.offset = this.address;
            this.bytesWritten += (long)count;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            JavaInternals.unsafe.freeMemory(this.address);
            this.address = 0L;
        }
    }

    @Override
    protected long alloc(int size) throws IOException {
        if (this.offset + (long)size > this.limit) {
            this.grow(size);
        }
        long currentOffset = this.offset;
        this.offset = currentOffset + (long)size;
        return currentOffset;
    }

    private void grow(int size) throws IOException {
        this.flush();
        if (size > this.available()) {
            long newAddress;
            JavaInternals.unsafe.freeMemory(this.address);
            int newBufSize = Math.max(size + 32768, this.available() * 3 / 2);
            this.address = newAddress = JavaInternals.unsafe.allocateMemory(newBufSize);
            this.offset = newAddress;
            this.limit = newAddress + (long)newBufSize;
        }
    }

    private boolean addSerializer(long uid) {
        long[] set = this.serializerSet;
        int mask = set.length - 1;
        int i = (int)uid & mask;
        while (set[i] != 0L) {
            if (set[i] == uid) {
                return false;
            }
            i = i + 1 & mask;
        }
        set[i] = uid;
        if (uid != 0L && ++this.serializerSetSize * 2 > this.serializerSet.length) {
            this.resizeSerializerSet();
        }
        return true;
    }

    private void resizeSerializerSet() {
        long[] set = new long[this.serializerSet.length * 2];
        int mask = set.length - 1;
        for (long uid : this.serializerSet) {
            if (uid == 0L) continue;
            int i = (int)uid & mask;
            while (set[i] != 0L) {
                i = i + 1 & mask;
            }
            set[i] = uid;
        }
        this.serializerSet = set;
    }
}

