/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.serial.DataStream;
import one.nio.serial.Repository;
import one.nio.serial.SerializationContext;
import one.nio.serial.Serializer;

public class SerializeStream
extends DataStream {
    protected SerializationContext context = new SerializationContext();

    public SerializeStream(byte[] array) {
        super(array);
    }

    public SerializeStream(long address, long length) {
        super(address, length);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeByte(-1);
        } else {
            int index = this.context.put(obj);
            if (index < 0) {
                Serializer<?> serializer = Repository.get(obj.getClass());
                if (serializer.uid < 0L) {
                    this.writeByte((byte)serializer.uid);
                } else {
                    this.writeLong(serializer.uid);
                }
                serializer.write(obj, this);
            } else if (index <= 65535) {
                this.writeByte(-2);
                this.writeShort(index);
            } else {
                this.writeByte(-3);
                this.writeInt(index);
            }
        }
    }

    @Override
    public void close() {
        this.context = null;
    }
}

