/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import java.io.IOException;
import one.nio.net.Session;
import one.nio.net.Socket;
import one.nio.net.SslContext;
import one.nio.server.AcceptorConfig;
import one.nio.server.RejectedSessionException;
import one.nio.server.Server;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class AcceptorThread
extends Thread {
    private static final Log log = LogFactory.getLog(AcceptorThread.class);
    final String address;
    final int port;
    final int backlog;
    final Server server;
    final Socket serverSocket;
    volatile long acceptedSessions;
    volatile long rejectedSessions;

    AcceptorThread(Server server, AcceptorConfig config) throws IOException {
        super("NIO Acceptor " + config.address + ":" + config.port);
        this.address = config.address;
        this.port = config.port;
        this.backlog = config.backlog;
        this.server = server;
        Socket serverSocket = Socket.createServerSocket();
        if (config.ssl != null) {
            SslContext sslContext = SslContext.create();
            sslContext.configure(config.ssl);
            serverSocket = serverSocket.sslWrap(sslContext);
        }
        this.serverSocket = serverSocket;
        if (config.recvBuf != 0) {
            serverSocket.setRecvBuffer(config.recvBuf);
        }
        if (config.sendBuf != 0) {
            serverSocket.setSendBuffer(config.sendBuf);
        }
        if (config.tos != 0) {
            serverSocket.setTos(config.tos);
        }
        if (config.deferAccept) {
            serverSocket.setDeferAccept(true);
        }
        serverSocket.setNoDelay(config.noDelay);
        serverSocket.setTcpFastOpen(config.tcpFastOpen);
        serverSocket.setReuseAddr(true, config.reusePort);
        serverSocket.bind(this.address, this.port, this.backlog);
    }

    void reconfigure(AcceptorConfig config) throws IOException {
        if (config.recvBuf != 0) {
            this.serverSocket.setRecvBuffer(config.recvBuf);
        }
        if (config.sendBuf != 0) {
            this.serverSocket.setSendBuffer(config.sendBuf);
        }
        if (config.tos != 0) {
            this.serverSocket.setTos(config.tos);
        }
        this.serverSocket.setDeferAccept(config.deferAccept);
        this.serverSocket.setNoDelay(config.noDelay);
        this.serverSocket.setTcpFastOpen(config.tcpFastOpen);
        this.serverSocket.setReuseAddr(true, config.reusePort);
        SslContext sslContext = this.serverSocket.getSslContext();
        if (sslContext != null && config.ssl != null) {
            sslContext.configure(config.ssl);
        }
    }

    void shutdown() {
        this.serverSocket.close();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            this.serverSocket.listen(this.backlog);
        }
        catch (IOException e) {
            log.error((Object)("Cannot start listening at " + this.port));
            return;
        }
        while (this.serverSocket.isOpen()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.acceptNonBlocking();
                Session session = this.server.createSession(socket);
                this.server.register(session);
                ++this.acceptedSessions;
            }
            catch (RejectedSessionException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rejected session from " + socket.getRemoteAddress()), (Throwable)e);
                }
                ++this.rejectedSessions;
                socket.close();
            }
            catch (Throwable e) {
                if (this.serverSocket.isOpen()) {
                    log.error((Object)"Cannot accept incoming connection", e);
                }
                if (socket == null) continue;
                socket.close();
            }
        }
    }
}

