/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;

public final class JavaInternals {
    public static final Unsafe unsafe = JavaInternals.getUnsafe();
    public static final long byteArrayOffset = unsafe.arrayBaseOffset(byte[].class);

    public static Unsafe getUnsafe() {
        try {
            return (Unsafe)JavaInternals.getField(Unsafe.class, "theUnsafe").get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Field getField(Class<?> cls, String name) {
        Field f = JavaInternals.findField(cls, name);
        if (f != null) {
            f.setAccessible(true);
        }
        return f;
    }

    public static Field findField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Field findField(String cls, String name) {
        try {
            return JavaInternals.findField(Class.forName(cls), name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Field findFieldRecursively(Class<?> cls, String name) {
        while (cls != null) {
            Field f = JavaInternals.findField(cls, name);
            if (f != null) {
                return f;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> ... params) {
        Method m = JavaInternals.findMethod(cls, name, params);
        if (m != null) {
            m.setAccessible(true);
        }
        return m;
    }

    public static Method findMethod(Class<?> cls, String name, Class<?> ... params) {
        try {
            return cls.getDeclaredMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method findMethod(String cls, String name, Class<?> ... params) {
        try {
            return JavaInternals.findMethod(Class.forName(cls), name, params);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Method findMethodRecursively(Class<?> cls, String name, Class<?> ... params) {
        while (cls != null) {
            Method m = JavaInternals.findMethod(cls, name, params);
            if (m != null) {
                return m;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> cls, Class<?> ... params) {
        Constructor<T> c = JavaInternals.findConstructor(cls, params);
        if (c != null) {
            c.setAccessible(true);
        }
        return c;
    }

    public static <T> Constructor<T> findConstructor(Class<T> cls, Class<?> ... params) {
        try {
            return cls.getDeclaredConstructor(params);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Constructor<?> findConstructor(String cls, Class<?> ... params) {
        try {
            return JavaInternals.findConstructor(Class.forName(cls), params);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static long fieldOffset(Class<?> cls, String name) {
        try {
            return unsafe.objectFieldOffset(cls.getDeclaredField(name));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static long fieldOffset(String cls, String name) {
        try {
            return JavaInternals.fieldOffset(Class.forName(cls), name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setStaticField(Class<?> cls, String name, Object value) {
        try {
            Field field = cls.getDeclaredField(name);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Static field expected");
            }
            unsafe.putObject(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field), value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setObjectField(Object obj, String name, Object value) {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Object field expected");
            }
            unsafe.putObject(obj, unsafe.objectFieldOffset(field), value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <E extends Throwable> void uncheckedThrow(Throwable e) throws E {
        throw e;
    }
}

