/*
 * Decompiled with CFR 0.152.
 */
package one.nio.async;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.os.BatchThread;

public class CustomThreadFactory
implements ThreadFactory,
ForkJoinPool.ForkJoinWorkerThreadFactory {
    private final String name;
    private final boolean daemon;
    private final boolean batch;
    private final AtomicInteger id = new AtomicInteger();

    public CustomThreadFactory(String name) {
        this(name, false, false);
    }

    public CustomThreadFactory(String name, boolean daemon) {
        this(name, daemon, false);
    }

    public CustomThreadFactory(String name, boolean daemon, boolean batch) {
        this.name = name;
        this.daemon = daemon;
        this.batch = batch;
    }

    @Override
    public Thread newThread(Runnable r) {
        String nextThreadName = this.name + "-" + this.id.incrementAndGet();
        Thread thread = this.batch ? new BatchThread(r, nextThreadName) : new Thread(r, nextThreadName);
        thread.setDaemon(this.daemon);
        return thread;
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        ForkJoinWorkerThread thread = new ForkJoinWorkerThread(pool){

            @Override
            protected void onStart() {
                super.onStart();
                if (CustomThreadFactory.this.batch) {
                    BatchThread.adjustPriority();
                }
            }
        };
        thread.setName(this.name + "-" + this.id.incrementAndGet());
        return thread;
    }
}

