/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import one.nio.mem.DirectMemory;
import one.nio.mem.LongHashSet;
import one.nio.mem.OutOfMemoryException;

public class LongLongHashMap
extends LongHashSet {
    protected long values;

    public LongLongHashMap(int capacity) {
        super(capacity);
        this.values = DirectMemory.allocateAndClear((long)this.capacity * 8L, this);
    }

    public LongLongHashMap(int capacity, long keys, long values) {
        super(capacity, keys);
        this.values = values;
    }

    public long get(long key) {
        int index = this.getKey(key);
        return index >= 0 ? this.valueAt(index) : 0L;
    }

    public void put(long key, long value) {
        int index = this.putKey(key);
        this.setValueAt(index, value);
    }

    public long putIfAbsent(long key, long value) {
        int step = 1;
        int index = LongLongHashMap.hash(key) % this.capacity;
        do {
            long cur;
            if ((cur = this.keyAt(index)) == 0L) {
                if (!unsafe.compareAndSwapLong(null, this.keys + (long)index * 8L, cur, key)) continue;
                this.setValueAt(index, value);
                this.incrementSize();
                return 0L;
            }
            if (cur == key) {
                return this.valueAt(index);
            }
            if ((index += step) < this.capacity) continue;
            index -= this.capacity;
        } while (++step <= this.maxSteps);
        throw new OutOfMemoryException("No room for a new key");
    }

    public boolean replace(long key, long oldValue, long newValue) {
        int index = this.getKey(key);
        return index >= 0 && unsafe.compareAndSwapLong(null, this.values + (long)index * 8L, oldValue, newValue);
    }

    public long replace(long key, long newValue) {
        int index = this.putKey(key);
        return this.replaceValueAt(index, newValue);
    }

    public long adjustOrPut(long key, long delta) {
        int index = this.putKey(key);
        return this.adjustValueAt(index, delta);
    }

    public long remove(long key) {
        int index = this.getKey(key);
        return index >= 0 ? this.replaceValueAt(index, 0L) : 0L;
    }

    public final long valueAt(int index) {
        return unsafe.getLongVolatile(null, this.values + (long)index * 8L);
    }

    public final void setValueAt(int index, long value) {
        unsafe.putOrderedLong(null, this.values + (long)index * 8L, value);
    }

    public final long replaceValueAt(int index, long newValue) {
        long oldValue;
        long address = this.values + (long)index * 8L;
        while (!unsafe.compareAndSwapLong(null, address, oldValue = unsafe.getLongVolatile(null, address), newValue)) {
        }
        return oldValue;
    }

    public final long adjustValueAt(int index, long delta) {
        long newValue;
        long oldValue;
        long address = this.values + (long)index * 8L;
        while (!unsafe.compareAndSwapLong(null, address, oldValue = unsafe.getLongVolatile(null, address), newValue = oldValue + delta)) {
        }
        return newValue;
    }

    @Override
    public void clear() {
        super.clear();
        unsafe.setMemory(this.values, (long)this.capacity * 8L, (byte)0);
    }

    public static long sizeInBytes(int capacity) {
        return (long)capacity * 16L;
    }
}

