/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import one.nio.os.perf.Perf;
import one.nio.os.perf.PerfEvent;
import one.nio.os.perf.PerfSample;
import one.nio.os.perf.RingBuffer;

public class PerfCounter
implements Closeable {
    private final PerfEvent event;
    private final RingBuffer ringBuffer;
    volatile int fd;
    static final AtomicIntegerFieldUpdater<PerfCounter> fdUpdater = AtomicIntegerFieldUpdater.newUpdater(PerfCounter.class, "fd");

    PerfCounter(PerfEvent event, RingBuffer ringBuffer, int fd) {
        this.event = event;
        this.ringBuffer = ringBuffer;
        this.fd = fd;
    }

    public final PerfEvent event() {
        return this.event;
    }

    @Override
    public void close() {
        int fd = this.fd;
        if (fdUpdater.compareAndSet(this, fd, -1)) {
            Perf.close(fd);
            if (this.ringBuffer != null) {
                this.ringBuffer.close();
            }
        }
    }

    public long get() throws IOException {
        return Perf.get(this.fd);
    }

    public PerfSample nextSample() {
        if (this.ringBuffer == null) {
            throw new IllegalStateException("Not a sampling counter");
        }
        return this.ringBuffer.nextSample();
    }

    public void reset() {
        this.ioctl(0, 0);
    }

    public void enable() {
        this.ioctl(1, 0);
    }

    public void disable() {
        this.ioctl(2, 0);
    }

    public void refresh(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be > 0");
        }
        this.ioctl(3, count);
    }

    void ioctl(int cmd, int arg) {
        Perf.ioctl(this.fd, cmd, arg);
    }
}

