/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import java.io.IOException;
import one.nio.os.perf.Perf;
import one.nio.os.perf.PerfCounter;
import one.nio.os.perf.PerfEvent;

public class PerfCounterGlobal
extends PerfCounter {
    private final int[] fds;

    PerfCounterGlobal(PerfEvent event, int[] fds) {
        super(event, null, 0);
        this.fds = fds;
    }

    @Override
    public void close() {
        if (fdUpdater.compareAndSet(this, 0, -1)) {
            for (int i = 0; i < this.fds.length; ++i) {
                int fd = this.fds[i];
                this.fds[i] = -1;
                Perf.close(fd);
            }
        }
    }

    @Override
    public long get() throws IOException {
        long sum = 0L;
        for (int fd : this.fds) {
            sum += Perf.get(fd);
        }
        return sum;
    }

    public long getForCpu(int cpu) throws IOException {
        return Perf.get(this.fds[cpu]);
    }

    @Override
    void ioctl(int cmd, int arg) {
        for (int fd : this.fds) {
            Perf.ioctl(fd, cmd, arg);
        }
    }
}

