/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.util.Base64;
import one.nio.util.ByteArrayBuilder;

public class JsonReader {
    protected byte[] array;
    protected int offset;
    protected int next;

    public JsonReader(byte[] array) {
        this(array, 0);
    }

    public JsonReader(byte[] array, int offset) {
        this.array = array;
        this.offset = offset;
        this.skipWhitespace();
    }

    protected int read() {
        int b = this.next;
        this.next = this.offset < this.array.length ? this.array[this.offset++] & 0xFF : -1;
        return b;
    }

    public final int next() {
        return this.next;
    }

    public final int skipWhitespace() {
        while (this.next <= 32 && this.next != -1) {
            this.read();
        }
        return this.next;
    }

    public final IOException exception(String message) {
        return new IOException(message + " at " + this.offset);
    }

    public final void expect(int b, String message) throws IOException {
        if (this.read() != b) {
            throw this.exception(message);
        }
    }

    public final boolean readBoolean() throws IOException {
        int b = this.read();
        if (b == 116 && this.read() == 114 && this.read() == 117 && this.read() == 101) {
            return true;
        }
        if (b == 102 && this.read() == 97 && this.read() == 108 && this.read() == 115 && this.read() == 101) {
            return false;
        }
        throw this.exception("Expected boolean");
    }

    public final byte readByte() throws IOException {
        return Byte.parseByte(this.readNumber());
    }

    public final short readShort() throws IOException {
        return Short.parseShort(this.readNumber());
    }

    public final char readChar() throws IOException {
        return this.readString().charAt(0);
    }

    public final int readInt() throws IOException {
        return Integer.parseInt(this.readNumber());
    }

    public final long readLong() throws IOException {
        return Long.parseLong(this.readNumber());
    }

    public float readFloat() throws IOException {
        return Float.parseFloat(this.readNumber());
    }

    public final double readDouble() throws IOException {
        return Double.parseDouble(this.readNumber());
    }

    public final String readNumber() throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.next == 45) {
            sb.append((char)this.read());
        }
        int nochars = sb.length();
        while (this.next >= 48 && this.next <= 57) {
            sb.append((char)this.read());
        }
        if (this.next == 46) {
            sb.append((char)this.read());
            if (this.next < 48 || this.next > 57) {
                throw this.exception("Expected number");
            }
            do {
                sb.append((char)this.read());
            } while (this.next >= 48 && this.next <= 57);
        }
        if (sb.length() <= nochars) {
            throw this.exception("Expected number");
        }
        if (this.next == 101 || this.next == 69) {
            sb.append((char)this.read());
            if (this.next == 45 || this.next == 43) {
                sb.append((char)this.read());
            }
            if (this.next < 48 || this.next > 57) {
                throw this.exception("Expected number");
            }
            do {
                sb.append((char)this.read());
            } while (this.next >= 48 && this.next <= 57);
        }
        return sb.toString();
    }

    public final int readHexChar() throws IOException {
        int b = this.read();
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 65 && b <= 70) {
            return b - 65;
        }
        if (b >= 97 && b <= 102) {
            return b - 97;
        }
        throw this.exception("Invalid escape character");
    }

    public final char readEscapeChar() throws IOException {
        int b = this.read();
        switch (b) {
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 117: {
                return (char)(this.readHexChar() << 12 | this.readHexChar() << 8 | this.readHexChar() << 4 | this.readHexChar());
            }
        }
        return (char)b;
    }

    public Object readNull() throws IOException {
        if (this.read() != 110 || this.read() != 117 || this.read() != 108 || this.read() != 108) {
            throw this.exception("Expected null");
        }
        return null;
    }

    public String readString() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.expect(34, "Expected string");
        while (this.next >= 0 && this.next != 34) {
            int b = this.read();
            if ((b & 0x80) == 0) {
                sb.append(b == 92 ? this.readEscapeChar() : (char)b);
                continue;
            }
            if ((b & 0xE0) == 192) {
                sb.append((char)((b & 0x1F) << 6 | this.read() & 0x3F));
                continue;
            }
            if ((b & 0xF0) == 224) {
                sb.append((char)((b & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F));
                continue;
            }
            int v = (b & 7) << 18 | (this.read() & 0x3F) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F;
            sb.append((char)(0xD800 | v - 65536 >>> 10)).append((char)(0xDC00 | v & 0x3FF));
        }
        this.expect(34, "Unexpected end of string");
        return sb.toString();
    }

    public byte[] readBinary() throws IOException {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        this.expect(34, "Expected BASE64 data");
        while (this.next >= 0 && this.next != 34) {
            builder.append((byte)this.read());
        }
        this.expect(34, "Unexpected end of BASE64 data");
        return Base64.decode(builder.buffer(), builder.length());
    }

    public ArrayList<Object> readArray() throws IOException, ClassNotFoundException {
        ArrayList<Object> result = new ArrayList<Object>();
        this.expect(91, "Expected array");
        boolean needComma = false;
        while (this.skipWhitespace() != 93) {
            if (needComma) {
                this.expect(44, "Unexpected end of array");
                this.skipWhitespace();
            }
            result.add(this.readObject());
            needComma = true;
        }
        this.read();
        return result;
    }

    public ArrayList<Object> readArray(Type elementType) throws IOException, ClassNotFoundException {
        ArrayList<Object> result = new ArrayList<Object>();
        this.expect(91, "Expected array");
        boolean needComma = false;
        while (this.skipWhitespace() != 93) {
            if (needComma) {
                this.expect(44, "Unexpected end of array");
                this.skipWhitespace();
            }
            result.add(this.readObject(elementType));
            needComma = true;
        }
        this.read();
        return result;
    }

    public Map<String, Object> readMap() throws IOException, ClassNotFoundException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.expect(123, "Expected map");
        boolean needComma = false;
        while (this.skipWhitespace() != 125) {
            if (needComma) {
                this.expect(44, "Unexpected end of map");
                this.skipWhitespace();
            }
            String key = this.readString();
            this.skipWhitespace();
            this.expect(58, "Expected key-value pair");
            this.skipWhitespace();
            result.put(key, this.readObject());
            needComma = true;
        }
        this.read();
        return result;
    }

    public <K> Map<K, Object> readMap(Class<K> keyClass, Type valueType) throws IOException, ClassNotFoundException {
        Serializer<K> keySerializer = Repository.get(keyClass);
        LinkedHashMap<K, Object> result = new LinkedHashMap<K, Object>();
        this.expect(123, "Expected map");
        boolean needComma = false;
        while (this.skipWhitespace() != 125) {
            if (needComma) {
                this.expect(44, "Unexpected end of map");
                this.skipWhitespace();
            }
            String key = this.readString();
            this.skipWhitespace();
            this.expect(58, "Expected key-value pair");
            this.skipWhitespace();
            result.put(keySerializer.fromString(key), this.readObject(valueType));
            needComma = true;
        }
        this.read();
        return result;
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        switch (this.next) {
            case 110: {
                return this.readNull();
            }
            case 102: 
            case 116: {
                return this.readBoolean();
            }
            case 34: {
                return this.readString();
            }
            case 91: {
                return this.readArray();
            }
            case 123: {
                return this.readMap();
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return JsonReader.parseNumber(this.readNumber());
            }
        }
        throw this.exception("Expected JSON object");
    }

    public <T> T readObject(Class<T> cls) throws IOException, ClassNotFoundException {
        return Repository.get(cls).fromJson(this);
    }

    public Object readObject(Type type) throws IOException, ClassNotFoundException {
        ParameterizedType ptype;
        if (type instanceof Class) {
            return Repository.get((Class)type).fromJson(this);
        }
        if (type instanceof ParameterizedType && (ptype = (ParameterizedType)type).getRawType() instanceof Class) {
            Class rawType = (Class)ptype.getRawType();
            Type[] args = ptype.getActualTypeArguments();
            if (Collection.class.isAssignableFrom(rawType) && args.length > 0) {
                return this.readArray(args[0]);
            }
            if (Map.class.isAssignableFrom(rawType) && args.length > 1 && args[0] instanceof Class) {
                return this.readMap((Class)args[0], args[1]);
            }
            return Repository.get(rawType).fromJson(this);
        }
        throw this.exception("Unsupported object type: " + type);
    }

    private static Number parseNumber(String number) {
        int length = number.length();
        for (int i = 0; i < length; ++i) {
            char c = number.charAt(i);
            if (c != '.' && c <= '9') continue;
            return Double.parseDouble(number);
        }
        long n = Long.parseLong(number);
        return n == (long)((int)n) ? (long)Integer.valueOf((int)n).intValue() : Long.valueOf(n);
    }
}

