/*
 * Decompiled with CFR 0.152.
 */
package one.nio.lock;

import one.nio.lock.FairRWLock;
import one.nio.lock.RWLock;

public class SegmentedRWLock {
    private final RWLock[] locks;

    public SegmentedRWLock(int count) {
        this(count, false);
    }

    public SegmentedRWLock(int count, boolean fair) {
        if ((count & count - 1) != 0) {
            throw new IllegalArgumentException("count must be power of 2");
        }
        this.locks = new RWLock[count];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = fair ? new FairRWLock() : new RWLock();
        }
    }

    public RWLock lockFor(long n) {
        return this.locks[(int)n & this.locks.length - 1];
    }

    public RWLock lockFor(int n) {
        return this.locks[n & this.locks.length - 1];
    }
}

