/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import one.nio.mem.DirectMemory;
import one.nio.net.SelectableJavaSocket;
import one.nio.net.Socket;
import one.nio.net.SocketClosedException;
import one.nio.net.SslContext;
import one.nio.net.SslOption;

final class JavaSocket
extends SelectableJavaSocket {
    final SocketChannel ch;
    int timeout;

    JavaSocket() throws IOException {
        this.ch = SocketChannel.open();
    }

    JavaSocket(SocketChannel ch) {
        this.ch = ch;
    }

    @Override
    public final boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public final void close() {
        try {
            this.ch.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final Socket accept() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void connect(InetAddress address, int port) throws IOException {
        this.ch.socket().connect(new InetSocketAddress(address, port), this.ch.socket().getSoTimeout());
    }

    @Override
    public final void bind(InetAddress address, int port, int backlog) throws IOException {
        this.ch.bind(new InetSocketAddress(address, port));
    }

    @Override
    public final void listen(int backlog) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int writeRaw(long buf, int count, int flags) throws IOException {
        this.checkTimeout(POLL_WRITE, this.timeout);
        return this.ch.write(DirectMemory.wrap(buf, count));
    }

    @Override
    public final int write(byte[] data, int offset, int count, int flags) throws IOException {
        this.checkTimeout(POLL_WRITE, this.timeout);
        return this.ch.write(ByteBuffer.wrap(data, offset, count));
    }

    @Override
    public final void writeFully(byte[] data, int offset, int count) throws IOException {
        this.ch.socket().getOutputStream().write(data, offset, count);
    }

    @Override
    public final int send(ByteBuffer src, int flags, InetAddress address, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int readRaw(long buf, int count, int flags) throws IOException {
        this.checkTimeout(POLL_READ, this.timeout);
        int result = this.ch.read(DirectMemory.wrap(buf, count));
        if (result < 0) {
            throw new SocketClosedException();
        }
        return result;
    }

    @Override
    public final int read(byte[] data, int offset, int count, int flags) throws IOException {
        this.checkTimeout(POLL_READ, this.timeout);
        int result = this.ch.read(ByteBuffer.wrap(data, offset, count));
        if (result < 0) {
            throw new SocketClosedException();
        }
        return result;
    }

    @Override
    public final InetSocketAddress recv(ByteBuffer dst, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void readFully(byte[] data, int offset, int count) throws IOException {
        InputStream in = this.ch.socket().getInputStream();
        while (count > 0) {
            int bytes = in.read(data, offset, count);
            if (bytes < 0) {
                throw new SocketClosedException();
            }
            offset += bytes;
            count -= bytes;
        }
    }

    @Override
    public final long sendFile(RandomAccessFile file, long offset, long count) throws IOException {
        return file.getChannel().transferTo(offset, count, this.ch);
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        this.checkTimeout(POLL_READ, this.timeout);
        return this.ch.read(dst);
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        this.checkTimeout(POLL_WRITE, this.timeout);
        return this.ch.write(src);
    }

    @Override
    public final void setBlocking(boolean blocking) {
        try {
            this.ch.configureBlocking(blocking);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isBlocking() {
        return this.ch.isBlocking();
    }

    @Override
    public final void setTimeout(int timeout) {
        try {
            this.ch.socket().setSoTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.timeout = timeout;
    }

    @Override
    public int getTimeout() {
        try {
            return this.ch.socket().getSoTimeout();
        }
        catch (SocketException e) {
            return 0;
        }
    }

    @Override
    public final void setKeepAlive(boolean keepAlive) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)keepAlive);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean getKeepAlive() {
        try {
            return this.ch.getOption(StandardSocketOptions.SO_KEEPALIVE);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public final void setNoDelay(boolean noDelay) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)noDelay);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean getNoDelay() {
        try {
            return this.ch.getOption(StandardSocketOptions.TCP_NODELAY);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public final void setTcpFastOpen(boolean tcpFastOpen) {
    }

    @Override
    public boolean getTcpFastOpen() {
        return false;
    }

    @Override
    public final void setDeferAccept(boolean deferAccept) {
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    @Override
    public final void setReuseAddr(boolean reuseAddr, boolean reusePort) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)reuseAddr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean getReuseAddr() {
        try {
            return this.ch.getOption(StandardSocketOptions.SO_REUSEADDR);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean getReusePort() {
        return false;
    }

    @Override
    public final void setRecvBuffer(int recvBuf) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)recvBuf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getRecvBuffer() {
        try {
            return this.ch.getOption(StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public final void setSendBuffer(int sendBuf) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)sendBuf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getSendBuffer() {
        try {
            return this.ch.getOption(StandardSocketOptions.SO_SNDBUF);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public final void setTos(int tos) {
        try {
            this.ch.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)tos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getTos() {
        try {
            return this.ch.getOption(StandardSocketOptions.IP_TOS);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public final byte[] getOption(int level, int option) {
        return null;
    }

    @Override
    public final boolean setOption(int level, int option, byte[] value) {
        return false;
    }

    @Override
    public final InetSocketAddress getLocalAddress() {
        try {
            return (InetSocketAddress)this.ch.getLocalAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        try {
            return (InetSocketAddress)this.ch.getRemoteAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Socket sslWrap(SslContext context) {
        return this;
    }

    @Override
    public Socket sslUnwrap() {
        return this;
    }

    @Override
    public SslContext getSslContext() {
        return null;
    }

    @Override
    public <T> T getSslOption(SslOption<T> option) {
        return null;
    }

    @Override
    public SelectableChannel getSelectableChannel() {
        return this.ch;
    }
}

