/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.nio.channels.SelectableChannel;
import one.nio.net.Socket;
import one.nio.util.JavaInternals;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;

public abstract class SelectableJavaSocket
extends Socket {
    private static final MethodHandle poll = SelectableJavaSocket.getPollMethodHandle();
    static final int POLL_READ = Net.POLLIN;
    static final int POLL_WRITE = Net.POLLOUT;

    private static MethodHandle getPollMethodHandle() {
        try {
            Method m = JavaInternals.getMethod(Net.class, "poll", FileDescriptor.class, Integer.TYPE, Long.TYPE);
            if (m != null) {
                return MethodHandles.publicLookup().unreflect(m);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    void checkTimeout(int events, long timeout) throws IOException {
        if (timeout <= 0L || poll == null) {
            return;
        }
        try {
            long endTime = System.currentTimeMillis() + timeout;
            do {
                int result;
                if ((result = poll.invokeExact(((SelChImpl)((Object)this.getSelectableChannel())).getFD(), events, timeout)) <= 0) continue;
                return;
            } while ((timeout = endTime - System.currentTimeMillis()) > 0L);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            return;
        }
        throw new SocketTimeoutException();
    }

    public abstract SelectableChannel getSelectableChannel();
}

