/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.bpf;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import one.nio.os.perf.Perf;

public class Handle
implements Closeable {
    private volatile int fd;
    static final AtomicIntegerFieldUpdater<Handle> fdUpdater = AtomicIntegerFieldUpdater.newUpdater(Handle.class, "fd");

    public Handle(int fd) {
        if (fd <= 0) {
            throw new IllegalArgumentException("Invalid " + this.getClass().getSimpleName() + " fd: " + fd);
        }
        this.fd = fd;
    }

    protected int fd() {
        if (this.fd <= 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is closed");
        }
        return this.fd;
    }

    @Override
    public void close() {
        int fd = this.fd;
        if (fdUpdater.compareAndSet(this, fd, -1)) {
            Perf.close(fd);
        }
    }
}

