/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import one.nio.os.perf.CounterValue;

public class GlobalValue
implements CounterValue {
    private final long[] buffer;

    GlobalValue(long[] buffer) {
        this.buffer = buffer;
    }

    @Override
    public double scalingFactor() {
        return 1.0 / this.runningFraction();
    }

    @Override
    public double runningFraction() {
        long enabled = 0L;
        long running = 0L;
        for (int i = 0; i < this.buffer.length; i += 3) {
            enabled += this.buffer[i + 1];
            running += this.buffer[i + 2];
        }
        return enabled == running ? 1.0 : 1.0 * (double)running / (double)enabled;
    }

    @Override
    public long normalized() {
        double total = 0.0;
        for (int i = 0; i < this.buffer.length; i += 3) {
            long value = this.buffer[i];
            long enabled = this.buffer[i + 1];
            long running = this.buffer[i + 2];
            if (enabled == running) {
                total += (double)value;
                continue;
            }
            if (running <= 0L) continue;
            total += (double)value * (double)enabled / (double)running;
        }
        return (long)total;
    }

    @Override
    public CounterValue sub(CounterValue prev) {
        return this.sub((GlobalValue)prev);
    }

    public GlobalValue sub(GlobalValue prev) {
        long[] buffer = (long[])this.buffer.clone();
        for (int i = 0; i < buffer.length; ++i) {
            int n = i;
            buffer[n] = buffer[n] - prev.buffer[i];
        }
        return new GlobalValue(buffer);
    }
}

