/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial.gen;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.gen.BytecodeGenerator;
import one.nio.serial.Default;
import one.nio.serial.FieldDescriptor;
import one.nio.serial.JsonName;
import one.nio.serial.Repository;
import one.nio.serial.SerializeWith;
import one.nio.serial.gen.FieldType;
import one.nio.util.Hex;
import one.nio.util.JavaFeatures;
import one.nio.util.JavaInternals;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class DelegateGenerator
extends BytecodeGenerator {
    private static final AtomicInteger index = new AtomicInteger();
    private static final String MAGIC_CLASS = "sun/reflect/MagicAccessorImpl";

    private static void defineBootstrapClass(Method m, String classData) throws ReflectiveOperationException {
        byte[] code = Hex.parseBytes(classData);
        m.invoke(null, null, null, code, 0, code.length, null, null);
    }

    public static byte[] generate(Class cls, FieldDescriptor[] fds, FieldDescriptor[] defaultFields) {
        String className = "sun/reflect/Delegate" + index.getAndIncrement() + '_' + cls.getSimpleName();
        ClassWriter cv = new ClassWriter(3);
        cv.visit(50, 17, className, null, MAGIC_CLASS, new String[]{"one/nio/serial/gen/Delegate"});
        DelegateGenerator.generateConstructor((ClassVisitor)cv);
        DelegateGenerator.generateCalcSize((ClassVisitor)cv, cls, fds);
        DelegateGenerator.generateWrite((ClassVisitor)cv, cls, fds);
        DelegateGenerator.generateRead((ClassVisitor)cv, cls, fds, defaultFields);
        DelegateGenerator.generateSkip((ClassVisitor)cv, fds);
        DelegateGenerator.generateToJson((ClassVisitor)cv, cls, fds);
        DelegateGenerator.generateFromJson((ClassVisitor)cv, cls, fds, defaultFields);
        cv.visitEnd();
        return cv.toByteArray();
    }

    private static void generateConstructor(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, MAGIC_CLASS, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateCalcSize(ClassVisitor cv, Class cls, FieldDescriptor[] fds) {
        MethodVisitor mv = cv.visitMethod(17, "calcSize", "(Ljava/lang/Object;Lone/nio/serial/CalcSizeStream;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        DelegateGenerator.emitTypeCast(mv, Object.class, cls);
        mv.visitVarInsn(58, 1);
        Method writeObjectMethod = JavaInternals.findMethodRecursively(cls, "writeObject", ObjectOutputStream.class);
        if (writeObjectMethod != null && !Repository.hasOptions(writeObjectMethod.getDeclaringClass(), 2)) {
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(178, "one/nio/serial/gen/NullObjectOutputStream", "INSTANCE", "Lone/nio/serial/gen/NullObjectOutputStream;");
            DelegateGenerator.emitInvoke(mv, writeObjectMethod);
        }
        int primitiveFieldsSize = 0;
        for (FieldDescriptor fd : fds) {
            Field ownField = fd.ownField();
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            if (srcType != FieldType.Object) {
                primitiveFieldsSize += srcType.dataSize;
                continue;
            }
            if (ownField == null) {
                ++primitiveFieldsSize;
                continue;
            }
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            if (fd.parentField() != null) {
                DelegateGenerator.emitGetField(mv, fd.parentField());
            }
            DelegateGenerator.emitGetSerialField(mv, ownField);
            DelegateGenerator.emitTypeCast(mv, ownField.getType(), sourceClass);
            mv.visitMethodInsn(182, "one/nio/serial/CalcSizeStream", "writeObject", "(Ljava/lang/Object;)V");
        }
        if (primitiveFieldsSize != 0) {
            mv.visitVarInsn(25, 2);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, "one/nio/serial/CalcSizeStream", "count", "I");
            DelegateGenerator.emitInt(mv, primitiveFieldsSize);
            mv.visitInsn(96);
            mv.visitFieldInsn(181, "one/nio/serial/CalcSizeStream", "count", "I");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateWrite(ClassVisitor cv, Class cls, FieldDescriptor[] fds) {
        MethodVisitor mv = cv.visitMethod(17, "write", "(Ljava/lang/Object;Lone/nio/serial/DataStream;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        DelegateGenerator.emitTypeCast(mv, Object.class, cls);
        mv.visitVarInsn(58, 1);
        Method writeObjectMethod = JavaInternals.findMethodRecursively(cls, "writeObject", ObjectOutputStream.class);
        if (writeObjectMethod != null && !Repository.hasOptions(writeObjectMethod.getDeclaringClass(), 2)) {
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(178, "one/nio/serial/gen/NullObjectOutputStream", "INSTANCE", "Lone/nio/serial/gen/NullObjectOutputStream;");
            DelegateGenerator.emitInvoke(mv, writeObjectMethod);
        }
        for (FieldDescriptor fd : fds) {
            Field ownField = fd.ownField();
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            mv.visitVarInsn(25, 2);
            if (ownField == null) {
                mv.visitInsn(FieldType.Void.convertTo(srcType));
            } else {
                mv.visitVarInsn(25, 1);
                if (fd.parentField() != null) {
                    DelegateGenerator.emitGetField(mv, fd.parentField());
                }
                DelegateGenerator.emitGetSerialField(mv, ownField);
                DelegateGenerator.emitTypeCast(mv, ownField.getType(), sourceClass);
            }
            mv.visitMethodInsn(182, "one/nio/serial/DataStream", srcType.writeMethod(), srcType.writeSignature());
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateRead(ClassVisitor cv, Class cls, FieldDescriptor[] fds, FieldDescriptor[] defaultFields) {
        Method readObjectMethod;
        MethodVisitor mv = cv.visitMethod(17, "read", "(Lone/nio/serial/DataStream;)Ljava/lang/Object;", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(187, org.objectweb.asm.Type.getInternalName((Class)cls));
        mv.visitInsn(90);
        mv.visitMethodInsn(182, "one/nio/serial/DataStream", "register", "(Ljava/lang/Object;)V");
        ArrayList<Field> parents = new ArrayList<Field>();
        boolean isRecord = JavaFeatures.isRecord(cls);
        for (FieldDescriptor fd : fds) {
            Field ownField = fd.ownField();
            Field parentField = fd.parentField();
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            if (parentField != null && !parents.contains(parentField)) {
                parents.add(parentField);
                if (!isRecord) {
                    mv.visitInsn(89);
                }
                mv.visitTypeInsn(187, org.objectweb.asm.Type.getInternalName(parentField.getType()));
                mv.visitInsn(89);
                mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
                DelegateGenerator.emitPutSerialField(mv, parentField, isRecord, fd);
            }
            if (ownField == null) {
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "one/nio/serial/DataStream", srcType.readMethod(), srcType.readSignature());
                mv.visitInsn(srcType.convertTo(FieldType.Void));
                continue;
            }
            if (!isRecord) {
                mv.visitInsn(89);
            }
            if (parentField != null) {
                DelegateGenerator.emitGetField(mv, parentField);
            }
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "one/nio/serial/DataStream", srcType.readMethod(), srcType.readSignature());
            if (srcType == FieldType.Object) {
                DelegateGenerator.emitTypeCast(mv, Object.class, sourceClass);
            }
            DelegateGenerator.emitTypeCast(mv, sourceClass, ownField.getType());
            DelegateGenerator.emitPutSerialField(mv, ownField, isRecord, fd);
        }
        for (FieldDescriptor defaultField : defaultFields) {
            DelegateGenerator.setDefaultField(mv, defaultField, isRecord);
        }
        if (isRecord) {
            DelegateGenerator.generateCreateRecord(mv, cls, fds, defaultFields);
        }
        if ((readObjectMethod = JavaInternals.findMethodRecursively(cls, "readObject", ObjectInputStream.class)) != null && !Repository.hasOptions(readObjectMethod.getDeclaringClass(), 1)) {
            mv.visitInsn(89);
            mv.visitFieldInsn(178, "one/nio/serial/gen/NullObjectInputStream", "INSTANCE", "Lone/nio/serial/gen/NullObjectInputStream;");
            DelegateGenerator.emitInvoke(mv, readObjectMethod);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateSkip(ClassVisitor cv, FieldDescriptor[] fds) {
        MethodVisitor mv = cv.visitMethod(17, "skip", "(Lone/nio/serial/DataStream;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        mv.visitCode();
        int skipSize = 0;
        for (FieldDescriptor fd : fds) {
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            if (srcType != FieldType.Object) {
                skipSize += srcType.dataSize;
                continue;
            }
            if (skipSize > 0) {
                mv.visitVarInsn(25, 1);
                DelegateGenerator.emitInt(mv, skipSize);
                mv.visitMethodInsn(182, "one/nio/serial/DataStream", "skipBytes", "(I)I");
                mv.visitInsn(87);
                skipSize = 0;
            }
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "one/nio/serial/DataStream", "readObject", "()Ljava/lang/Object;");
            mv.visitInsn(87);
        }
        if (skipSize > 0) {
            mv.visitVarInsn(25, 1);
            DelegateGenerator.emitInt(mv, skipSize);
            mv.visitMethodInsn(182, "one/nio/serial/DataStream", "skipBytes", "(I)I");
            mv.visitInsn(87);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateToJson(ClassVisitor cv, Class cls, FieldDescriptor[] fds) {
        MethodVisitor mv = cv.visitMethod(17, "toJson", "(Ljava/lang/Object;Ljava/lang/StringBuilder;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        DelegateGenerator.emitTypeCast(mv, Object.class, cls);
        mv.visitVarInsn(58, 1);
        boolean firstWritten = false;
        mv.visitVarInsn(25, 2);
        block4: for (FieldDescriptor fd : fds) {
            Field ownField = fd.ownField();
            if (ownField == null) continue;
            JsonName jsonName = ownField.getAnnotation(JsonName.class);
            String fieldName = jsonName != null ? jsonName.value() : ownField.getName();
            mv.visitLdcInsn((Object)((firstWritten ? (char)',' : '{') + "\"" + fieldName + "\":"));
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            firstWritten = true;
            Class sourceClass = fd.type().resolve();
            FieldType srcType = FieldType.valueOf(sourceClass);
            mv.visitVarInsn(25, 1);
            if (fd.parentField() != null) {
                DelegateGenerator.emitGetField(mv, fd.parentField());
            }
            DelegateGenerator.emitGetSerialField(mv, ownField);
            DelegateGenerator.emitTypeCast(mv, ownField.getType(), sourceClass);
            switch (srcType) {
                case Object: {
                    mv.visitMethodInsn(184, "one/nio/serial/Json", "appendObject", "(Ljava/lang/StringBuilder;Ljava/lang/Object;)V");
                    mv.visitVarInsn(25, 2);
                    continue block4;
                }
                case Char: {
                    mv.visitMethodInsn(184, "one/nio/serial/Json", "appendChar", "(Ljava/lang/StringBuilder;C)V");
                    mv.visitVarInsn(25, 2);
                    continue block4;
                }
                default: {
                    mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", srcType.appendSignature());
                }
            }
        }
        if (!firstWritten) {
            DelegateGenerator.emitInt(mv, 123);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(C)Ljava/lang/StringBuilder;");
        }
        DelegateGenerator.emitInt(mv, 125);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(C)Ljava/lang/StringBuilder;");
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateFromJson(ClassVisitor cv, Class cls, FieldDescriptor[] fds, FieldDescriptor[] defaultFields) {
        Method readObjectMethod;
        int i;
        Field ownField;
        MethodVisitor mv = cv.visitMethod(17, "fromJson", "(Lone/nio/serial/JsonReader;)Ljava/lang/Object;", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitIntInsn(16, 123);
        mv.visitLdcInsn((Object)"Expected object");
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "expect", "(ILjava/lang/String;)V");
        mv.visitTypeInsn(187, org.objectweb.asm.Type.getInternalName((Class)cls));
        TreeMap<Integer, FieldDescriptor> fieldHashes = new TreeMap<Integer, FieldDescriptor>();
        boolean isRecord = JavaFeatures.isRecord(cls);
        for (FieldDescriptor fd : fds) {
            ownField = fd.ownField();
            if (ownField == null) continue;
            fd.next = fieldHashes.put(ownField.getName().hashCode(), fd);
            DelegateGenerator.setDefaultField(mv, fd, isRecord);
        }
        for (FieldDescriptor fd : defaultFields) {
            ownField = fd.ownField();
            fd.next = fieldHashes.put(ownField.getName().hashCode(), fd);
            DelegateGenerator.setDefaultField(mv, fd, isRecord);
        }
        Label done = new Label();
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "skipWhitespace", "()I");
        mv.visitIntInsn(16, 125);
        mv.visitJumpInsn(159, done);
        Label loop = new Label();
        mv.visitLabel(loop);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readString", "()Ljava/lang/String;");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "skipWhitespace", "()I");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitIntInsn(16, 58);
        mv.visitLdcInsn((Object)"Expected key-value pair");
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "expect", "(ILjava/lang/String;)V");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "skipWhitespace", "()I");
        mv.visitInsn(87);
        Label parseNextField = new Label();
        Label skipUnknownField = new Label();
        Label[] switchLabels = new Label[fieldHashes.size()];
        if (switchLabels.length > 1) {
            int[] switchKeys = new int[switchLabels.length];
            i = 0;
            for (Integer key : fieldHashes.keySet()) {
                switchKeys[i] = key;
                switchLabels[i] = new Label();
                ++i;
            }
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, "java/lang/String", "hashCode", "()I");
            mv.visitLookupSwitchInsn(skipUnknownField, switchKeys, switchLabels);
        }
        ArrayList<Field> parents = new ArrayList<Field>();
        i = 0;
        for (FieldDescriptor fd : fieldHashes.values()) {
            if (switchLabels[i] != null) {
                mv.visitLabel(switchLabels[i++]);
            }
            do {
                Label next = new Label();
                mv.visitVarInsn(25, 2);
                mv.visitLdcInsn((Object)fd.ownField().getName());
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                mv.visitJumpInsn(153, fd.next == null ? skipUnknownField : next);
                DelegateGenerator.generateReadJsonField(mv, fd, parents, isRecord);
                mv.visitJumpInsn(167, parseNextField);
                mv.visitLabel(next);
            } while ((fd = fd.next) != null);
        }
        mv.visitLabel(skipUnknownField);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readObject", "()Ljava/lang/Object;");
        mv.visitInsn(87);
        mv.visitLabel(parseNextField);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "skipWhitespace", "()I");
        mv.visitIntInsn(16, 125);
        mv.visitJumpInsn(159, done);
        mv.visitVarInsn(25, 1);
        mv.visitIntInsn(16, 44);
        mv.visitLdcInsn((Object)"Unexpected end of object");
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "expect", "(ILjava/lang/String;)V");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "skipWhitespace", "()I");
        mv.visitInsn(87);
        mv.visitJumpInsn(167, loop);
        mv.visitLabel(done);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "read", "()I");
        mv.visitInsn(87);
        if (isRecord) {
            DelegateGenerator.generateCreateRecord(mv, cls, fds, defaultFields);
        }
        if ((readObjectMethod = JavaInternals.findMethodRecursively(cls, "readObject", ObjectInputStream.class)) != null && !Repository.hasOptions(readObjectMethod.getDeclaringClass(), 1)) {
            mv.visitInsn(89);
            mv.visitFieldInsn(178, "one/nio/serial/gen/NullObjectInputStream", "INSTANCE", "Lone/nio/serial/gen/NullObjectInputStream;");
            DelegateGenerator.emitInvoke(mv, readObjectMethod);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateReadJsonField(MethodVisitor mv, FieldDescriptor fd, List<Field> parents, boolean isRecord) {
        Field ownField = fd.ownField();
        Field parentField = fd.parentField();
        if (parentField != null && !parents.contains(parentField)) {
            parents.add(parentField);
            if (!isRecord) {
                mv.visitInsn(89);
            }
            mv.visitTypeInsn(187, org.objectweb.asm.Type.getInternalName(parentField.getType()));
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
            DelegateGenerator.emitPutSerialField(mv, parentField, isRecord, fd);
        }
        if (!isRecord) {
            mv.visitInsn(89);
        }
        if (parentField != null) {
            DelegateGenerator.emitGetField(mv, parentField);
        }
        DelegateGenerator.generateReadJsonFieldInternal(mv, ownField);
        DelegateGenerator.emitPutSerialField(mv, ownField, isRecord, fd);
    }

    private static void generateReadJsonFieldInternal(MethodVisitor mv, Field ownField) {
        Class<?> fieldClass = ownField.getType();
        if (fieldClass.isPrimitive()) {
            FieldType fieldType = FieldType.valueOf(fieldClass);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "one/nio/serial/JsonReader", fieldType.readMethod(), fieldType.readSignature());
            return;
        }
        Label done = new Label();
        Label notNull = new Label();
        mv.visitVarInsn(25, 1);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "one/nio/serial/JsonReader", "next", "I");
        DelegateGenerator.emitInt(mv, 110);
        mv.visitJumpInsn(160, notNull);
        mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readNull", "()Ljava/lang/Object;");
        mv.visitJumpInsn(167, done);
        mv.visitLabel(notNull);
        if (fieldClass == String.class) {
            mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readString", "()Ljava/lang/String;");
        } else if (fieldClass.isArray() && !fieldClass.getComponentType().isPrimitive()) {
            Class<?> componentType = fieldClass.getComponentType();
            if (DelegateGenerator.isConcreteClass(componentType)) {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(componentType));
                mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readArray", "(Ljava/lang/reflect/Type;)Ljava/util/ArrayList;");
                DelegateGenerator.emitInt(mv, 0);
                mv.visitTypeInsn(189, org.objectweb.asm.Type.getInternalName(componentType));
                mv.visitMethodInsn(182, "java/util/ArrayList", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                mv.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(fieldClass));
            } else {
                mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readArray", "()Ljava/util/ArrayList;");
                mv.visitMethodInsn(182, "java/util/ArrayList", "toArray", "()[Ljava/lang/Object;");
                DelegateGenerator.emitTypeCast(mv, Object[].class, fieldClass);
            }
        } else if (Collection.class.isAssignableFrom(fieldClass)) {
            Type[] args;
            Type genericType = ownField.getGenericType();
            if (genericType instanceof ParameterizedType && (args = ((ParameterizedType)genericType).getActualTypeArguments()).length > 0 && args[0] instanceof Class && DelegateGenerator.isConcreteClass((Class)args[0])) {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)((Class)args[0])));
                mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readArray", "(Ljava/lang/reflect/Type;)Ljava/util/ArrayList;");
                DelegateGenerator.emitTypeCast(mv, ArrayList.class, fieldClass);
            } else {
                mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readArray", "()Ljava/util/ArrayList;");
                DelegateGenerator.emitTypeCast(mv, ArrayList.class, fieldClass);
            }
        } else if (Map.class.isAssignableFrom(fieldClass)) {
            Type[] args;
            Type genericType = ownField.getGenericType();
            if (genericType instanceof ParameterizedType && (args = ((ParameterizedType)genericType).getActualTypeArguments()).length > 1 && args[0] instanceof Class && args[1] instanceof Class && DelegateGenerator.isConcreteClass((Class)args[1])) {
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)((Class)args[0])));
                mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)((Class)args[1])));
                mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readMap", "(Ljava/lang/Class;Ljava/lang/reflect/Type;)Ljava/util/Map;");
                DelegateGenerator.emitTypeCast(mv, Map.class, fieldClass);
            } else {
                mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readMap", "()Ljava/util/Map;");
                DelegateGenerator.emitTypeCast(mv, Map.class, fieldClass);
            }
        } else if (DelegateGenerator.isConcreteClass(fieldClass)) {
            mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(fieldClass));
            mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readObject", "(Ljava/lang/Class;)Ljava/lang/Object;");
            DelegateGenerator.emitTypeCast(mv, Object.class, fieldClass);
        } else {
            mv.visitMethodInsn(182, "one/nio/serial/JsonReader", "readObject", "()Ljava/lang/Object;");
            DelegateGenerator.emitTypeCast(mv, Object.class, fieldClass);
        }
        mv.visitLabel(done);
    }

    private static void generateCreateRecord(MethodVisitor mv, Class<?> cls, FieldDescriptor[] fds, FieldDescriptor[] defaultFields) {
        int length;
        Class[] args = new Class[fds.length + defaultFields.length];
        for (FieldDescriptor fd : fds) {
            if (fd.ownField() == null) continue;
            args[fd.index()] = fd.ownField().getType();
        }
        for (FieldDescriptor fd : defaultFields) {
            args[fd.index()] = fd.ownField().getType();
        }
        for (length = args.length; length > 0 && args[length - 1] == null; --length) {
        }
        if (length != args.length) {
            args = Arrays.copyOf(args, length);
        }
        mv.visitInsn(89);
        for (int i = 0; i < length; ++i) {
            mv.visitVarInsn(org.objectweb.asm.Type.getType((Class)args[i]).getOpcode(21), 3 + i * 2);
        }
        try {
            DelegateGenerator.emitInvoke(mv, cls.getConstructor(args));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot find matching canonical constructor for " + cls.getName());
        }
    }

    private static boolean isConcreteClass(Class cls) {
        return cls != Object.class && !cls.isInterface();
    }

    private static void setDefaultField(MethodVisitor mv, FieldDescriptor fd, boolean isRecord) {
        Field field = fd.ownField();
        Default defaultValue = field.getAnnotation(Default.class);
        if (defaultValue == null && !isRecord) {
            return;
        }
        Class<?> fieldType = field.getType();
        if (!isRecord) {
            mv.visitInsn(89);
        }
        if (defaultValue == null) {
            mv.visitInsn(FieldType.Void.convertTo(FieldType.valueOf(fieldType)));
        } else if (!defaultValue.method().isEmpty()) {
            int p;
            String methodName = defaultValue.method();
            Method m = JavaInternals.findMethod(methodName.substring(0, p = methodName.lastIndexOf(46)), methodName.substring(p + 1), new Class[0]);
            if (m == null || !Modifier.isStatic(m.getModifiers()) || !fieldType.isAssignableFrom(m.getReturnType())) {
                throw new IllegalArgumentException("Invalid default initializer " + methodName + " for field " + field);
            }
            DelegateGenerator.emitInvoke(mv, m);
        } else if (!defaultValue.field().isEmpty()) {
            int p;
            String fieldName = defaultValue.field();
            Field f = JavaInternals.findField(fieldName.substring(0, p = fieldName.lastIndexOf(46)), fieldName.substring(p + 1));
            if (f == null || !Modifier.isStatic(f.getModifiers()) || !fieldType.isAssignableFrom(f.getType())) {
                throw new IllegalArgumentException("Invalid default initializer " + fieldName + " for field " + field);
            }
            DelegateGenerator.emitGetField(mv, f);
        } else {
            DelegateGenerator.emitDefaultValue(mv, field, fieldType, defaultValue.value());
        }
        DelegateGenerator.emitPutSerialField(mv, field, isRecord, fd);
    }

    private static void emitDefaultValue(MethodVisitor mv, Field field, Class<?> fieldType, String value) {
        switch (FieldType.valueOf(fieldType)) {
            case Int: 
            case Byte: 
            case Short: {
                DelegateGenerator.emitInt(mv, Integer.decode(value));
                return;
            }
            case Long: {
                DelegateGenerator.emitLong(mv, Long.decode(value));
                return;
            }
            case Boolean: {
                DelegateGenerator.emitInt(mv, Boolean.parseBoolean(value) ? 1 : 0);
                return;
            }
            case Char: {
                DelegateGenerator.emitInt(mv, value.length() == 1 ? value.charAt(0) : Integer.decode(value).intValue());
                return;
            }
            case Float: {
                DelegateGenerator.emitFloat(mv, Float.parseFloat(value));
                return;
            }
            case Double: {
                DelegateGenerator.emitDouble(mv, Double.parseDouble(value));
                return;
            }
        }
        if (fieldType == String.class) {
            mv.visitLdcInsn((Object)value);
        } else if (fieldType == Character.class) {
            DelegateGenerator.emitInt(mv, value.length() == 1 ? value.charAt(0) : Integer.decode(value).intValue());
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (fieldType == Class.class) {
            mv.visitLdcInsn((Object)org.objectweb.asm.Type.getObjectType((String)value.replace('.', '/')));
        } else {
            try {
                Method valueOf = fieldType.getMethod("valueOf", String.class);
                if (!Modifier.isStatic(valueOf.getModifiers()) || valueOf.getReturnType() != fieldType) {
                    throw new NoSuchMethodException("valueOf(String) is not found in class " + fieldType.getName());
                }
                mv.visitLdcInsn((Object)value);
                DelegateGenerator.emitInvoke(mv, valueOf);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Cannot set default value \"" + value + "\" to " + field, e);
            }
        }
    }

    private static void emitTypeCast(MethodVisitor mv, Class<?> src, Class<?> dst) {
        if (src == dst || dst.isAssignableFrom(src)) {
            return;
        }
        if (src.isPrimitive() && dst.isPrimitive()) {
            FieldType srcType = FieldType.valueOf(src);
            FieldType dstType = FieldType.valueOf(dst);
            for (int opcode = srcType.convertTo(dstType); opcode != 0; opcode >>>= 8) {
                mv.visitInsn(opcode & 0xFF);
            }
            return;
        }
        if (src.isArray() && dst.isArray() && src.getComponentType().isPrimitive() == dst.getComponentType().isPrimitive()) {
            String copySig;
            Label isNull = DelegateGenerator.emitNullGuard(mv, dst);
            mv.visitInsn(89);
            mv.visitInsn(190);
            Class<?> dstComponent = dst.getComponentType();
            if (dstComponent.isPrimitive()) {
                mv.visitIntInsn(188, FieldType.valueOf(dstComponent).bytecodeType);
                copySig = "(" + org.objectweb.asm.Type.getDescriptor(src) + org.objectweb.asm.Type.getDescriptor(dst) + ")V";
            } else {
                mv.visitTypeInsn(189, org.objectweb.asm.Type.getInternalName(dstComponent));
                copySig = "([Ljava/lang/Object;[Ljava/lang/Object;)V";
            }
            mv.visitInsn(90);
            mv.visitMethodInsn(184, "one/nio/serial/gen/ArrayCopy", "copy", copySig);
            mv.visitLabel(isNull);
            return;
        }
        if (src.isAssignableFrom(dst)) {
            mv.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(dst));
            return;
        }
        if (src.getSuperclass() == Number.class && dst.getSuperclass() == Number.class) {
            Method[] isNull = dst.getMethods();
            int dstComponent = isNull.length;
            for (int i = 0; i < dstComponent; ++i) {
                Class<?> param;
                Method m = isNull[i];
                if (m.getParameterTypes().length != 1 || m.getReturnType() != dst || !Modifier.isStatic(m.getModifiers()) || !"valueOf".equals(m.getName()) || !(param = m.getParameterTypes()[0]).isPrimitive() || param == Boolean.TYPE || param == Character.TYPE) continue;
                Label isNull2 = DelegateGenerator.emitNullGuard(mv, dst);
                String valueMethod = param.getName() + "Value";
                String valueSignature = "()" + org.objectweb.asm.Type.getDescriptor(param);
                String valueOfSignature = "(" + org.objectweb.asm.Type.getDescriptor(param) + ")" + org.objectweb.asm.Type.getDescriptor(dst);
                mv.visitMethodInsn(182, "java/lang/Number", valueMethod, valueSignature);
                mv.visitMethodInsn(184, org.objectweb.asm.Type.getInternalName(dst), "valueOf", valueOfSignature);
                mv.visitLabel(isNull2);
                return;
            }
        }
        if (Collection.class.isAssignableFrom(src)) {
            Class<ArrayList> target;
            Class clazz = dst.isAssignableFrom(ArrayList.class) ? ArrayList.class : (target = dst.isAssignableFrom(HashSet.class) ? HashSet.class : null);
            if (target != null) {
                Label isNull = DelegateGenerator.emitNullGuard(mv, dst);
                mv.visitTypeInsn(187, org.objectweb.asm.Type.getInternalName(target));
                mv.visitInsn(90);
                mv.visitInsn(95);
                mv.visitMethodInsn(183, org.objectweb.asm.Type.getInternalName(target), "<init>", "(Ljava/util/Collection;)V");
                mv.visitLabel(isNull);
                return;
            }
        }
        try {
            Method m = dst.getMethod("valueOf", src);
            if (Modifier.isStatic(m.getModifiers()) && m.getReturnType() == dst) {
                DelegateGenerator.emitInvoke(mv, m);
                return;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Method m : src.getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0 || m.getReturnType() != dst) continue;
            Label isNull = DelegateGenerator.emitNullGuard(mv, dst);
            DelegateGenerator.emitInvoke(mv, m);
            mv.visitLabel(isNull);
            return;
        }
        mv.visitInsn(FieldType.valueOf(src).convertTo(FieldType.Void));
        mv.visitInsn(FieldType.Void.convertTo(FieldType.valueOf(dst)));
    }

    private static void emitGetSerialField(MethodVisitor mv, Field f) {
        SerializeWith serializeWith = f.getAnnotation(SerializeWith.class);
        if (serializeWith != null && !serializeWith.getter().isEmpty()) {
            try {
                Method m = f.getDeclaringClass().getDeclaredMethod(serializeWith.getter(), new Class[0]);
                if (Modifier.isStatic(m.getModifiers()) || m.getReturnType() != f.getType()) {
                    throw new IllegalArgumentException("Incompatible getter method: " + m);
                }
                DelegateGenerator.emitInvoke(mv, m);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Getter method not found", e);
            }
        } else {
            DelegateGenerator.emitGetField(mv, f);
        }
    }

    private static void emitPutSerialField(MethodVisitor mv, Field f, boolean isRecord, FieldDescriptor fd) {
        if (isRecord) {
            mv.visitVarInsn(org.objectweb.asm.Type.getType(f.getType()).getOpcode(54), 3 + fd.index() * 2);
            return;
        }
        SerializeWith serializeWith = f.getAnnotation(SerializeWith.class);
        if (serializeWith != null && !serializeWith.setter().isEmpty()) {
            try {
                Method m = f.getDeclaringClass().getDeclaredMethod(serializeWith.setter(), f.getType());
                if (Modifier.isStatic(m.getModifiers()) || m.getReturnType() != Void.TYPE) {
                    throw new IllegalArgumentException("Incompatible setter method: " + m);
                }
                DelegateGenerator.emitInvoke(mv, m);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Setter method not found", e);
            }
        } else if (Modifier.isFinal(f.getModifiers())) {
            FieldType dstType = FieldType.valueOf(f.getType());
            mv.visitLdcInsn((Object)JavaInternals.unsafe.objectFieldOffset(f));
            mv.visitMethodInsn(184, "one/nio/util/JavaInternals", dstType.putMethod(), dstType.putSignature());
        } else {
            DelegateGenerator.emitPutField(mv, f);
        }
    }

    private static Label emitNullGuard(MethodVisitor mv, Class<?> dst) {
        Label isNull = new Label();
        Label nonNull = new Label();
        mv.visitInsn(89);
        mv.visitJumpInsn(199, nonNull);
        mv.visitInsn(87);
        mv.visitInsn(FieldType.Void.convertTo(FieldType.valueOf(dst)));
        mv.visitJumpInsn(167, isNull);
        mv.visitLabel(nonNull);
        return isNull;
    }

    static {
        if (!System.getProperty("java.version").startsWith("1.")) {
            try {
                Method m = ClassLoader.class.getDeclaredMethod("defineClass1", ClassLoader.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class, String.class);
                m.setAccessible(true);
                DelegateGenerator.defineBootstrapClass(m, "cafebabe00000033000a0a000300070700080700090100063c696e69743e010003282956010004436f64650c000400050100286a646b2f696e7465726e616c2f7265666c6563742f4d616769634163636573736f724272696467650100266a646b2f696e7465726e616c2f7265666c6563742f4d616769634163636573736f72496d706c042100020003000000000001000100040005000100060000001100010001000000052ab70001b1000000000000");
                DelegateGenerator.defineBootstrapClass(m, "cafebabe00000033000a0a000300070700080700090100063c696e69743e010003282956010004436f64650c0004000501001d73756e2f7265666c6563742f4d616769634163636573736f72496d706c0100286a646b2f696e7465726e616c2f7265666c6563742f4d616769634163636573736f72427269646765042100020003000000000001000100040005000100060000001100010001000000052ab70001b1000000000000");
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

