/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.io.IOException;
import one.nio.mem.SharedMemoryLongMap;

public class SharedMemoryBlobMap
extends SharedMemoryLongMap<byte[]> {
    public SharedMemoryBlobMap(int capacity, String fileName, long fileSize) throws IOException {
        super(capacity, fileName, fileSize);
    }

    public SharedMemoryBlobMap(int capacity, String fileName, long fileSize, long expirationTime) throws IOException {
        super(capacity, fileName, fileSize, expirationTime);
    }

    @Override
    protected int sizeOf(byte[] value) {
        return value.length + 4;
    }

    @Override
    protected void setValueAt(long entry, byte[] value) {
        int length = value.length;
        unsafe.putInt(entry + 24L, length);
        unsafe.copyMemory(value, byteArrayOffset, null, entry + 28L, length);
    }

    @Override
    protected byte[] valueAt(long entry) {
        int length = unsafe.getInt(entry + 24L);
        byte[] value = new byte[length];
        unsafe.copyMemory(null, entry + 28L, value, byteArrayOffset, length);
        return value;
    }
}

