/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.util.Arrays;

public final class Msg {
    public static final int SCM_RIGHTS = 1;
    public static final int SCM_CREDENTIALS = 2;
    private byte[] data;
    private int cmsgType;
    private int[] cmsgData;

    public Msg(int capacity) {
        this.data = new byte[capacity];
    }

    public Msg(byte[] data) {
        this.data = data;
    }

    public byte[] data() {
        return this.data;
    }

    public int cmsgType() {
        return this.cmsgType;
    }

    public int[] cmsgData() {
        return this.cmsgData;
    }

    public Msg withCmsg(int type, int ... data) {
        if (this.cmsgType != 0) {
            throw new IllegalStateException("cmsg already set");
        }
        this.cmsgType = type;
        this.cmsgData = data;
        return this;
    }

    public Msg withFd(int fd) {
        return this.withCmsg(1, fd);
    }

    public Msg withFd(int ... fds) {
        return this.withCmsg(1, fds);
    }

    public Msg withCred(int pid, int uid, int gid) {
        return this.withCmsg(2, pid, uid, gid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Msg(").append(this.data == null ? 0 : this.data.length);
        if (this.cmsgType != 0) {
            sb.append(this.cmsgType == 1 ? " + SCM_RIGHTS" : " + SCM_CREDENTIALS");
            sb.append(Arrays.toString(this.cmsgData));
        }
        return sb.append(')').toString();
    }
}

