/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.net.ConnectException;
import one.nio.net.Proxy;
import one.nio.net.Socket;
import one.nio.util.ByteArrayBuilder;
import one.nio.util.Utf8;

public class SocksProxy
implements Proxy {
    private final String proxyHost;
    private final int proxyPort;
    private String user;
    private String password;

    public SocksProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public SocksProxy withAuth(String user, String password) {
        this.user = user;
        this.password = password;
        return this;
    }

    @Override
    public void connect(Socket socket, String host, int port) throws IOException {
        socket.connect(this.proxyHost, this.proxyPort);
        ByteArrayBuilder builder = new ByteArrayBuilder(400);
        byte authMethod = this.user == null || this.password == null ? (byte)0 : 2;
        builder.append((byte)5).append((byte)1).append(authMethod);
        if (authMethod != 0) {
            int userLength = Utf8.length(this.user);
            int passwordLength = Utf8.length(this.password);
            builder.append((byte)1).append((byte)userLength).append(this.user).append((byte)passwordLength).append(this.password);
        }
        builder.append((byte)5).append((byte)1).append((byte)0).append((byte)3).append((byte)host.length()).append(host).append((byte)(port >>> 8)).append((byte)port);
        socket.writeFully(builder.buffer(), 0, builder.length());
        this.readResponse(socket, builder.buffer(), authMethod);
    }

    private void readResponse(Socket socket, byte[] buf, byte authMethod) throws IOException {
        socket.readFully(buf, 0, 2);
        if (buf[0] != 5 || buf[1] != authMethod) {
            socket.close();
            throw new ConnectException("SocksProxy handshake error");
        }
        if (authMethod != 0) {
            socket.readFully(buf, 0, 2);
            if (buf[1] != 0) {
                socket.close();
                throw new ConnectException("SocksProxy auth error");
            }
        }
        socket.readFully(buf, 0, 10);
        if (buf[1] != 0) {
            socket.close();
            throw new ConnectException(SocksProxy.getErrorMessage(buf[1]));
        }
        if (buf[3] == 4) {
            socket.readFully(buf, 10, 12);
        }
    }

    private static String getErrorMessage(byte b) {
        switch (b) {
            case 1: {
                return "SocksProxy: general SOCKS server failure";
            }
            case 2: {
                return "SocksProxy: connection not allowed by ruleset";
            }
            case 3: {
                return "SocksProxy: Network unreachable";
            }
            case 4: {
                return "SocksProxy: Host unreachable";
            }
            case 5: {
                return "SocksProxy: Connection refused";
            }
            case 6: {
                return "SocksProxy: TTL expired";
            }
            case 7: {
                return "SocksProxy: Command not supported";
            }
            case 8: {
                return "SocksProxy: Address type not supported";
            }
        }
        return "SocksProxy connect error " + (b & 0xFF);
    }
}

