/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.JsonReader;
import one.nio.serial.Serializer;

class LongSerializer
extends Serializer<Long> {
    LongSerializer() {
        super(Long.class);
    }

    @Override
    public void calcSize(Long obj, CalcSizeStream css) {
        css.count += 8;
    }

    @Override
    public void write(Long v, DataStream out) throws IOException {
        out.writeLong(v);
    }

    @Override
    public Long read(DataStream in) throws IOException {
        Long result = in.readLong();
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException {
        in.skipBytes(8);
    }

    @Override
    public void toJson(Long obj, StringBuilder builder) {
        builder.append(obj);
    }

    @Override
    public Long fromJson(JsonReader in) throws IOException {
        return in.readLong();
    }

    @Override
    public Long fromString(String s) {
        return Long.valueOf(s);
    }
}

