/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.Array;
import java.util.ArrayList;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Json;
import one.nio.serial.JsonReader;
import one.nio.serial.Origin;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;

public class ObjectArraySerializer
extends Serializer<Object[]> {
    private Class componentType;

    ObjectArraySerializer(Class cls) {
        super(cls);
        this.componentType = cls.getComponentType();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(in);
        }
        catch (ClassNotFoundException e) {
            if ((Repository.getOptions() & 1) == 0) {
                throw e;
            }
            this.cls = Object[].class;
            this.origin = Origin.EXTERNAL;
        }
        this.componentType = this.cls.getComponentType();
    }

    @Override
    public void calcSize(Object[] obj, CalcSizeStream css) throws IOException {
        css.count += 4;
        for (Object v : obj) {
            css.writeObject(v);
        }
    }

    @Override
    public void write(Object[] obj, DataStream out) throws IOException {
        out.writeInt(obj.length);
        for (Object v : obj) {
            out.writeObject(v);
        }
    }

    @Override
    public Object[] read(DataStream in) throws IOException, ClassNotFoundException {
        Object[] result = (Object[])Array.newInstance(this.componentType, in.readInt());
        in.register(result);
        for (int i = 0; i < result.length; ++i) {
            result[i] = in.readObject();
        }
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            in.readObject();
        }
    }

    @Override
    public void toJson(Object[] obj, StringBuilder builder) throws IOException {
        builder.append('[');
        if (obj.length > 0) {
            Json.appendObject(builder, obj[0]);
            for (int i = 1; i < obj.length; ++i) {
                builder.append(',');
                Json.appendObject(builder, obj[i]);
            }
        }
        builder.append(']');
    }

    @Override
    public Object[] fromJson(JsonReader in) throws IOException, ClassNotFoundException {
        ArrayList<Object> list = in.readArray();
        return list.toArray((Object[])Array.newInstance(this.componentType, list.size()));
    }
}

