/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.Closeable;
import java.io.IOException;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Json;
import one.nio.serial.JsonReader;
import one.nio.serial.SerializedWrapper;
import one.nio.serial.Serializer;

class SerializedWrapperSerializer
extends Serializer<Object> {
    SerializedWrapperSerializer() {
        super(SerializedWrapper.class);
    }

    @Override
    public void calcSize(Object obj, CalcSizeStream css) throws IOException {
        css.add(SerializedWrapperSerializer.getSerialized(obj).length);
    }

    @Override
    public void write(Object obj, DataStream out) throws IOException {
        out.write(SerializedWrapperSerializer.getSerialized(obj));
    }

    @Override
    public Object read(DataStream in) throws IOException, ClassNotFoundException {
        Object result;
        try (Closeable blankScope = in.newScope();){
            result = in.readObject();
        }
        in.register(result);
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException, ClassNotFoundException {
        try (Closeable blankScope = in.newScope();){
            in.readObject();
        }
    }

    @Override
    public void toJson(Object obj, StringBuilder builder) throws IOException {
        Json.appendBinary(builder, SerializedWrapperSerializer.getSerialized(obj));
    }

    @Override
    public Object fromJson(JsonReader in) throws IOException, ClassNotFoundException {
        return Serializer.deserialize(in.readBinary());
    }

    private static byte[] getSerialized(Object obj) {
        return ((SerializedWrapper)obj).getSerialized();
    }
}

