/*
 * Decompiled with CFR 0.152.
 */
package one.nio.async;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.os.SchedulingPolicy;
import one.nio.server.PayloadThread;

public class CustomThreadFactory
implements ThreadFactory,
ForkJoinPool.ForkJoinWorkerThreadFactory {
    private final String name;
    private final boolean daemon;
    private final SchedulingPolicy schedulingPolicy;
    private final AtomicInteger id = new AtomicInteger();

    public CustomThreadFactory(String name) {
        this(name, false, null);
    }

    public CustomThreadFactory(String name, boolean daemon) {
        this(name, daemon, null);
    }

    public CustomThreadFactory(String name, boolean daemon, SchedulingPolicy schedulingPolicy) {
        this.name = name;
        this.daemon = daemon;
        this.schedulingPolicy = schedulingPolicy;
    }

    @Override
    public Thread newThread(Runnable r) {
        PayloadThread thread = new PayloadThread(r, this.name + "-" + this.id.incrementAndGet());
        thread.setDaemon(this.daemon);
        thread.setSchedulingPolicy(this.schedulingPolicy);
        return thread;
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        ForkJoinWorkerThread thread = new ForkJoinWorkerThread(pool){

            @Override
            protected void onStart() {
                super.onStart();
                if (CustomThreadFactory.this.schedulingPolicy != null) {
                    CustomThreadFactory.this.schedulingPolicy.apply();
                }
            }
        };
        thread.setName(this.name + "-" + this.id.incrementAndGet());
        return thread;
    }
}

