/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import one.nio.net.Proxy;
import one.nio.net.Socket;
import one.nio.util.Base64;
import one.nio.util.ByteArrayBuilder;

public class HttpProxy
implements Proxy {
    public static final int[] ALL_PORTS = null;
    private final String proxyHost;
    private final int proxyPort;
    private byte[] authHeader;
    private int[] connectPorts = new int[]{443};

    public HttpProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public HttpProxy withAuth(String user, String password) {
        this.authHeader = (byte[])(user == null || password == null ? null : new ByteArrayBuilder().append("Proxy-Authorization: Basic ").append(Base64.encode((user + ':' + password).getBytes(StandardCharsets.UTF_8))).append('\r').append('\n').toBytes());
        return this;
    }

    public HttpProxy withConnectPorts(int ... connectPorts) {
        if (connectPorts != null) {
            connectPorts = (int[])connectPorts.clone();
            Arrays.sort(connectPorts);
        }
        this.connectPorts = connectPorts;
        return this;
    }

    @Override
    public void connect(Socket socket, String host, int port) throws IOException {
        socket.connect(this.proxyHost, this.proxyPort);
        if (this.connectPorts != null && Arrays.binarySearch(this.connectPorts, port) < 0) {
            return;
        }
        ByteArrayBuilder builder = new ByteArrayBuilder(400).append("CONNECT ").append(host).append(':').append(port).append(" HTTP/1.1\r\n").append("Host: ").append(host).append(':').append(port).append('\r').append('\n');
        if (this.authHeader != null) {
            builder.append(this.authHeader);
        }
        builder.append('\r').append('\n');
        socket.writeFully(builder.buffer(), 0, builder.length());
        int statusCode = this.readResponse(socket, builder.buffer());
        if (statusCode != 200) {
            socket.close();
            throw new ConnectException("HttpProxy error " + statusCode);
        }
    }

    private int readResponse(Socket socket, byte[] buf) throws IOException {
        int pos = 0;
        do {
            if ((pos += socket.read(buf, pos, buf.length - pos)) != buf.length) continue;
            buf = Arrays.copyOf(buf, buf.length * 2);
        } while (pos < 16 || buf[pos - 4] != 13 || buf[pos - 3] != 10 || buf[pos - 2] != 13 || buf[pos - 1] != 10);
        return buf[9] * 100 + buf[10] * 10 + buf[11] - 5328;
    }
}

