/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import one.nio.os.Cpus;
import one.nio.os.NativeLibrary;
import one.nio.os.perf.PerfCounter;
import one.nio.os.perf.PerfCounterGlobal;
import one.nio.os.perf.PerfEvent;
import one.nio.os.perf.PerfOption;
import one.nio.os.perf.PerfOptionGlobalGroup;
import one.nio.os.perf.RingBuffer;

public class Perf {
    public static final boolean IS_SUPPORTED = NativeLibrary.IS_SUPPORTED && new File("/proc/sys/kernel/perf_event_paranoid").exists();
    public static final int CURRENT_PID = 0;
    public static final int ANY_PID = -1;
    public static final int ANY_CPU = -1;
    static final int IOCTL_RESET = 0;
    static final int IOCTL_ENABLE = 1;
    static final int IOCTL_DISABLE = 2;
    static final int IOCTL_REFRESH = 3;
    static final int IOCTL_PERIOD = 4;
    static final int IOCTL_SET_OUTPUT = 5;
    static final int IOCTL_SET_FILTER = 6;
    static final int IOCTL_ID = 7;
    static final int IOCTL_SET_BPF = 8;
    static final int IOCTL_PAUSE_OUTPUT = 9;

    public static PerfCounter open(PerfEvent event, int pid, int cpu, PerfOption ... options) throws IOException {
        if (cpu == -1 && (pid == -1 || Perf.hasOption(options, PerfOption.PID_CGROUP) || Perf.option(options, "GROUP_GLOBAL") != null)) {
            return Perf.openGlobal(event, pid, options);
        }
        int group = (int)Perf.optionValue(options, "GROUP");
        long readFormat = Perf.optionBits(options, "FORMAT");
        int fd = Perf.openEvent(pid, cpu, event.type, event.config, event.breakpoint, group, Perf.optionString(options));
        RingBuffer ringBuffer = Perf.createRingBuffer(fd, options);
        return new PerfCounter(event, ringBuffer, readFormat, fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerfCounter open(PerfEvent event, String cgroup, int cpu, PerfOption ... options) throws IOException {
        options = Arrays.copyOf(options, options.length + 1);
        options[options.length - 1] = PerfOption.PID_CGROUP;
        int fd = Perf.openFile("/sys/fs/cgroup/perf_event/" + cgroup);
        try {
            PerfCounter perfCounter = Perf.open(event, fd, cpu, options);
            return perfCounter;
        }
        finally {
            Perf.close(fd);
        }
    }

    public static PerfCounterGlobal openGlobal(PerfEvent event, int pid, PerfOption ... options) throws IOException {
        String optionString = Perf.optionString(options);
        int[] fds = new int[Cpus.COUNT];
        PerfOptionGlobalGroup group = (PerfOptionGlobalGroup)Perf.option(options, "GROUP_GLOBAL");
        try {
            for (int cpu = 0; cpu < fds.length; ++cpu) {
                if (!Cpus.ONLINE.get(cpu)) continue;
                int groupFd = group == null ? -1 : group.fds[cpu];
                fds[cpu] = Perf.openEvent(pid, cpu, event.type, event.config, event.breakpoint, groupFd, optionString);
            }
        }
        catch (Throwable e) {
            for (int fd : fds) {
                if (fd <= 0) continue;
                Perf.close(fd);
            }
            throw e;
        }
        long readFormat = Perf.optionBits(options, "FORMAT");
        return new PerfCounterGlobal(event, readFormat, fds);
    }

    private static RingBuffer createRingBuffer(int fd, PerfOption ... options) throws IOException {
        boolean useRingBuffer = false;
        int sampleType = 0;
        int pages = 1;
        for (PerfOption o : options) {
            String name = o.name;
            if (name == "PERIOD" || name == "FREQ") {
                useRingBuffer = true;
                continue;
            }
            if (name == "SAMPLE") {
                sampleType = (int)((long)sampleType | o.value);
                continue;
            }
            if (name == "FORMAT") {
                sampleType = (int)((long)sampleType | o.value << 24);
                continue;
            }
            if (name != "PAGES") continue;
            pages = (int)o.value;
        }
        if (!useRingBuffer) {
            return null;
        }
        try {
            return new RingBuffer(fd, pages, sampleType);
        }
        catch (Throwable e) {
            Perf.close(fd);
            throw e;
        }
    }

    private static String optionString(PerfOption[] options) {
        StringBuilder sb = new StringBuilder();
        for (PerfOption option : options) {
            sb.append(option).append(',');
        }
        return sb.toString();
    }

    private static long optionValue(PerfOption[] options, String name) {
        PerfOption o = Perf.option(options, name);
        return o == null ? -1L : o.value;
    }

    private static PerfOption option(PerfOption[] options, String name) {
        for (PerfOption o : options) {
            if (o.name != name) continue;
            return o;
        }
        return null;
    }

    private static long optionBits(PerfOption[] options, String name) {
        long value = 0L;
        for (PerfOption o : options) {
            if (o.name != name) continue;
            value |= o.value;
        }
        return value;
    }

    private static boolean hasOption(PerfOption[] options, PerfOption option) {
        for (PerfOption o : options) {
            if (o != option) continue;
            return true;
        }
        return false;
    }

    static native int openEvent(int var0, int var1, int var2, long var3, int var5, int var6, String var7) throws IOException;

    public static native int openFile(String var0) throws IOException;

    public static native void close(int var0);

    static native long get(int var0) throws IOException;

    static native void getValue(int var0, long[] var1, int var2, int var3) throws IOException;

    static native void ioctl(int var0, int var1, int var2) throws IOException;
}

