/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import java.io.Closeable;
import java.io.IOException;
import one.nio.os.Mem;
import one.nio.os.perf.PerfSample;
import one.nio.util.JavaInternals;

class RingBuffer
implements Closeable {
    private static final int PAGE_SIZE = JavaInternals.unsafe.pageSize();
    private static final int HEAD_OFFSET = 1024;
    private static final int TAIL_OFFSET = 1032;
    private static final int PERF_RECORD_SAMPLE = 9;
    private final long address;
    private final long mask;
    private final int sampleType;

    RingBuffer(int fd, int pages, int sampleType) throws IOException {
        if (pages <= 0 || (pages & pages - 1) != 0) {
            throw new IllegalArgumentException("Pages must be a power of 2");
        }
        this.address = Mem.mmap(0L, (long)((pages + 1) * PAGE_SIZE), 3, 1, fd, 0L);
        if (this.address == -1L) {
            throw new IOException("Unable to allocate perf ring buffer");
        }
        this.mask = pages * PAGE_SIZE - 1;
        this.sampleType = sampleType;
    }

    @Override
    public void close() {
        Mem.munmap(this.address, (long)PAGE_SIZE + this.mask + 1L);
    }

    PerfSample nextSample() {
        long head = JavaInternals.unsafe.getLongVolatile(null, this.address + 1024L);
        long tail = JavaInternals.unsafe.getLongVolatile(null, this.address + 1032L);
        while (tail < head) {
            long header = this.readLong(tail);
            int type = (int)header;
            int size = (int)(header >>> 48);
            if (type == 9) {
                PerfSample sample = this.readSample(tail);
                JavaInternals.unsafe.putLongVolatile(null, this.address + 1032L, tail + (long)size);
                return sample;
            }
            JavaInternals.unsafe.putLongVolatile(null, this.address + 1032L, tail += (long)size);
        }
        return null;
    }

    private PerfSample readSample(long offset) {
        int i;
        PerfSample sample = new PerfSample();
        if (this.hasOption(65536)) {
            sample.sampleId = this.readLong(offset += 8L);
        }
        if (this.hasOption(1)) {
            sample.ip = this.readLong(offset += 8L);
        }
        if (this.hasOption(2)) {
            long tid = this.readLong(offset += 8L);
            sample.pid = (int)tid;
            sample.tid = (int)(tid >>> 32);
        }
        if (this.hasOption(4)) {
            sample.time = this.readLong(offset += 8L);
        }
        if (this.hasOption(8)) {
            sample.addr = this.readLong(offset += 8L);
        }
        if (this.hasOption(64)) {
            sample.sampleId = this.readLong(offset += 8L);
        }
        if (this.hasOption(512)) {
            offset += 8L;
        }
        if (this.hasOption(128)) {
            long cpu = this.readLong(offset += 8L);
            sample.cpu = (int)cpu;
            sample.res = (int)(cpu >>> 32);
        }
        if (this.hasOption(256)) {
            sample.period = this.readLong(offset += 8L);
        }
        if (this.hasOption(16)) {
            int nr = this.hasOption(0x8000000) ? (int)this.readLong(offset += 8L) : 1;
            long[] values = new long[nr];
            for (i = 0; i < nr; ++i) {
                values[i] = this.readLong(offset += 8L);
            }
            sample.values = values;
        }
        if (this.hasOption(32)) {
            int nr = (int)this.readLong(offset += 8L);
            long[] callchain = new long[nr];
            for (i = 0; i < nr; ++i) {
                callchain[i] = this.readLong(offset += 8L);
            }
            sample.callchain = callchain;
        }
        return sample;
    }

    private boolean hasOption(int option) {
        return (this.sampleType & option) != 0;
    }

    private long readLong(long offset) {
        return JavaInternals.unsafe.getLong(this.address + (long)PAGE_SIZE + (offset & this.mask));
    }
}

