/*
 * Decompiled with CFR 0.152.
 */
package one.nio.rpc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import one.nio.serial.MethodSerializer;
import one.nio.serial.Repository;

public class RemoteCall
implements Serializable {
    private final MethodSerializer serializer;
    private final Object[] args;

    public RemoteCall(Method method, Object ... args) {
        this.serializer = Repository.registerMethod(method);
        this.args = args;
    }

    public RemoteCall(MethodSerializer serializer, Object ... args) {
        this.serializer = serializer;
        this.args = args;
    }

    public MethodSerializer serializer() {
        return this.serializer;
    }

    public Method method() {
        return this.serializer.method();
    }

    public Object[] args() {
        return this.args;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteCall) {
            return this.serializer.equals(((RemoteCall)obj).serializer);
        }
        return false;
    }

    public int hashCode() {
        return this.serializer.hashCode();
    }

    public String toString() {
        Method method = this.method();
        return method.getDeclaringClass().getName() + '.' + method.getName() + Arrays.toString(this.args);
    }
}

