/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Json;
import one.nio.serial.JsonReader;
import one.nio.serial.Serializer;
import one.nio.util.JavaInternals;

public class JavaTimeSerializer
extends Serializer {
    private MethodHandle writeExternal;
    private MethodHandle readExternal;

    JavaTimeSerializer(Class cls) {
        super(cls);
        this.initMethodHandles();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.initMethodHandles();
    }

    private void initMethodHandles() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            Method m = JavaInternals.getMethod(this.cls, "writeExternal", DataOutput.class);
            if (m == null && (m = JavaInternals.getMethod(this.cls, "writeExternal", ObjectOutput.class)) == null) {
                throw new IllegalStateException("writeExternal not found in " + this.cls);
            }
            this.writeExternal = lookup.unreflect(m).asType(MethodType.methodType(Void.TYPE, Object.class, DataOutput.class));
            m = JavaInternals.getMethod(this.cls, "readExternal", DataInput.class);
            if (m == null && (m = JavaInternals.getMethod(this.cls, "readExternal", ObjectInput.class)) == null) {
                throw new IllegalStateException("readExternal not found in " + this.cls);
            }
            this.readExternal = lookup.unreflect(m).asType(MethodType.methodType(Object.class, DataInput.class));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public void calcSize(Object obj, CalcSizeStream css) throws IOException {
        try {
            this.writeExternal.invokeExact(obj, css);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public void write(Object obj, DataStream out) throws IOException {
        try {
            this.writeExternal.invokeExact(obj, out);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public Object read(DataStream in) throws IOException, ClassNotFoundException {
        try {
            Object result = this.readExternal.invokeExact(in);
            in.register(result);
            return result;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataStream in) throws IOException, ClassNotFoundException {
        this.read(in);
    }

    public void toJson(Object obj, StringBuilder builder) throws NotSerializableException {
        Json.appendString(builder, obj.toString());
    }

    public Object fromJson(JsonReader in) throws NotSerializableException {
        throw new NotSerializableException(this.descriptor);
    }
}

