/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import one.nio.util.Utf8;

public class ByteArrayBuilder {
    protected static final byte[] TRUE = Utf8.toBytes("true");
    protected static final byte[] FALSE = Utf8.toBytes("false");
    protected byte[] buf;
    protected int count;

    public ByteArrayBuilder() {
        this(256);
    }

    public ByteArrayBuilder(int capacity) {
        this.buf = new byte[capacity];
    }

    public final byte[] buffer() {
        return this.buf;
    }

    public final int length() {
        return this.count;
    }

    public final void setLength(int newCount) {
        this.count = newCount;
    }

    public final int capacity() {
        return this.buf.length;
    }

    public final byte byteAt(int index) {
        return this.buf[index];
    }

    public final void crop(int offset) {
        if (offset < this.count) {
            this.count -= offset;
            System.arraycopy(this.buf, offset, this.buf, 0, this.count);
        } else {
            this.count = 0;
        }
    }

    public final byte[] trim() {
        if (this.buf.length > this.count) {
            this.buf = Arrays.copyOf(this.buf, this.count);
        }
        return this.buf;
    }

    public final byte[] toBytes() {
        byte[] result = new byte[this.count];
        System.arraycopy(this.buf, 0, result, 0, this.count);
        return result;
    }

    public final String toString() {
        return Utf8.read(this.buf, 0, this.count);
    }

    public final ByteArrayBuilder append(byte b) {
        this.ensureCapacity(1);
        this.buf[this.count++] = b;
        return this;
    }

    public final ByteArrayBuilder append(byte[] b) {
        return this.append(b, 0, b.length);
    }

    public final ByteArrayBuilder append(byte[] b, int offset, int length) {
        this.ensureCapacity(length);
        System.arraycopy(b, offset, this.buf, this.count, length);
        this.count += length;
        return this;
    }

    public final ByteArrayBuilder append(ByteBuffer bb, int length) {
        this.ensureCapacity(length);
        bb.get(this.buf, this.count, length);
        this.count += length;
        return this;
    }

    public final ByteArrayBuilder append(String s) {
        this.ensureCapacity(Utf8.length(s));
        this.count += Utf8.write(s, this.buf, this.count);
        return this;
    }

    public final ByteArrayBuilder append(boolean b) {
        this.append(b ? TRUE : FALSE);
        return this;
    }

    public final ByteArrayBuilder append(char c) {
        this.ensureCapacity(1);
        this.buf[this.count++] = (byte)c;
        return this;
    }

    public final ByteArrayBuilder append(int n) {
        this.ensureCapacity(11);
        this.appendNumber(n);
        return this;
    }

    public final ByteArrayBuilder append(long n) {
        this.ensureCapacity(20);
        this.appendNumber(n);
        return this;
    }

    public final ByteArrayBuilder appendCodePoint(int c) {
        this.ensureCapacity(3);
        if (c <= 127) {
            this.buf[this.count++] = (byte)c;
        } else if (c <= 2047) {
            this.buf[this.count] = (byte)(0xC0 | c >>> 6 & 0x1F);
            this.buf[this.count + 1] = (byte)(0x80 | c & 0x3F);
            this.count += 2;
        } else {
            this.buf[this.count] = (byte)(0xE0 | c >>> 12 & 0xF);
            this.buf[this.count + 1] = (byte)(0x80 | c >>> 6 & 0x3F);
            this.buf[this.count + 2] = (byte)(0x80 | c & 0x3F);
            this.count += 3;
        }
        return this;
    }

    public final ByteArrayBuilder appendHex(int n) {
        this.ensureCapacity(8);
        int i = this.count + 8;
        while (--i >= this.count) {
            int digit = n & 0xF;
            this.buf[i] = (byte)(digit < 10 ? digit + 48 : digit + 87);
            n >>>= 4;
        }
        this.count += 8;
        return this;
    }

    public final ByteArrayBuilder appendHex(long n) {
        this.ensureCapacity(16);
        int i = this.count + 16;
        while (--i >= this.count) {
            int digit = (int)n & 0xF;
            this.buf[i] = (byte)(digit < 10 ? digit + 48 : digit + 87);
            n >>>= 4;
        }
        this.count += 16;
        return this;
    }

    private void ensureCapacity(int required) {
        if (this.count + required > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.count + required, this.buf.length << 1));
        }
    }

    private void appendNumber(long n) {
        if (n < 0L) {
            if (n == Long.MIN_VALUE) {
                this.count += Utf8.write("-9223372036854775808", this.buf, this.count);
                return;
            }
            this.buf[this.count++] = 45;
            n = -n;
        }
        int i = this.count;
        for (long limit = 10L; n >= limit && limit > 0L; limit *= 10L) {
            ++i;
        }
        this.count = i + 1;
        do {
            this.buf[i--] = (byte)(n % 10L + 48L);
        } while ((n /= 10L) != 0L);
    }
}

