/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;

public final class JavaInternals {
    public static final Unsafe unsafe = JavaInternals.getUnsafe();
    public static final long byteArrayOffset = unsafe.arrayBaseOffset(byte[].class);
    private static final boolean hasModules = !System.getProperty("java.version").startsWith("1.");
    private static final long accessibleOffset = JavaInternals.getAccessibleOffset();

    public static Unsafe getUnsafe() {
        try {
            return (Unsafe)JavaInternals.getField(Unsafe.class, "theUnsafe").get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean hasModules() {
        return hasModules;
    }

    private static long getAccessibleOffset() {
        if (hasModules) {
            try {
                Method m0 = JavaInternals.class.getDeclaredMethod("getAccessibleOffset", new Class[0]);
                Method m1 = JavaInternals.class.getDeclaredMethod("getAccessibleOffset", new Class[0]);
                m1.setAccessible(true);
                for (long offset = 8L; offset < 128L; ++offset) {
                    if (unsafe.getByte(m0, offset) != 0 || unsafe.getByte(m1, offset) != 1) continue;
                    return offset;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static Field getField(Class<?> cls, String name) {
        Field f = JavaInternals.findField(cls, name);
        if (f != null) {
            JavaInternals.setAccessible(f);
        }
        return f;
    }

    public static Field findField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Field findField(String cls, String name) {
        try {
            return JavaInternals.findField(Class.forName(cls), name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Field findFieldRecursively(Class<?> cls, String name) {
        while (cls != null) {
            Field f = JavaInternals.findField(cls, name);
            if (f != null) {
                return f;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> ... params) {
        Method m = JavaInternals.findMethod(cls, name, params);
        if (m != null) {
            JavaInternals.setAccessible(m);
        }
        return m;
    }

    public static Method findMethod(Class<?> cls, String name, Class<?> ... params) {
        try {
            return cls.getDeclaredMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method findMethod(String cls, String name, Class<?> ... params) {
        try {
            return JavaInternals.findMethod(Class.forName(cls), name, params);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Method findMethodRecursively(Class<?> cls, String name, Class<?> ... params) {
        while (cls != null) {
            Method m = JavaInternals.findMethod(cls, name, params);
            if (m != null) {
                return m;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> cls, Class<?> ... params) {
        Constructor<T> c = JavaInternals.findConstructor(cls, params);
        if (c != null) {
            JavaInternals.setAccessible(c);
        }
        return c;
    }

    public static <T> Constructor<T> findConstructor(Class<T> cls, Class<?> ... params) {
        try {
            return cls.getDeclaredConstructor(params);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Constructor<?> findConstructor(String cls, Class<?> ... params) {
        try {
            return JavaInternals.findConstructor(Class.forName(cls), params);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void setAccessible(AccessibleObject ao) {
        if (accessibleOffset != 0L) {
            unsafe.putByte(ao, accessibleOffset, (byte)1);
        } else {
            ao.setAccessible(true);
        }
    }

    public static long fieldOffset(Class<?> cls, String name) {
        try {
            return unsafe.objectFieldOffset(cls.getDeclaredField(name));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static long fieldOffset(String cls, String name) {
        try {
            return JavaInternals.fieldOffset(Class.forName(cls), name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setStaticField(Class<?> cls, String name, Object value) {
        try {
            Field field = cls.getDeclaredField(name);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Static field expected");
            }
            unsafe.putObject(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field), value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setObjectField(Object obj, String name, Object value) {
        Class<?> cls = obj.getClass();
        JavaInternals.setObjectField(obj, cls, name, value);
    }

    public static void setObjectField(Object obj, Class<?> cls, String name, Object value) {
        try {
            Field field = cls.getDeclaredField(name);
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Object field expected");
            }
            unsafe.putObject(obj, unsafe.objectFieldOffset(field), value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <E extends Throwable> void uncheckedThrow(Throwable e) throws E {
        throw e;
    }

    public static void putObject(Object o, Object value, long offset) {
        unsafe.putObject(o, offset, value);
    }

    public static void putInt(Object o, int value, long offset) {
        unsafe.putInt(o, offset, value);
    }

    public static void putLong(Object o, long value, long offset) {
        unsafe.putLong(o, offset, value);
    }

    public static void putBoolean(Object o, boolean value, long offset) {
        unsafe.putBoolean(o, offset, value);
    }

    public static void putByte(Object o, byte value, long offset) {
        unsafe.putByte(o, offset, value);
    }

    public static void putShort(Object o, short value, long offset) {
        unsafe.putShort(o, offset, value);
    }

    public static void putChar(Object o, char value, long offset) {
        unsafe.putChar(o, offset, value);
    }

    public static void putFloat(Object o, float value, long offset) {
        unsafe.putFloat(o, offset, value);
    }

    public static void putDouble(Object o, double value, long offset) {
        unsafe.putDouble(o, offset, value);
    }
}

