/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.io.Closeable;
import one.nio.mem.DirectMemory;
import one.nio.util.JavaInternals;

public class OffheapBitSet
implements Closeable {
    protected long baseAddr;
    protected long size;

    public OffheapBitSet(long numBits) {
        this.size = OffheapBitSet.bits2words(numBits);
        this.baseAddr = DirectMemory.allocateRaw(this.size * 8L);
    }

    public OffheapBitSet(long address, long sizeBytes) {
        this.baseAddr = address;
        this.size = sizeBytes >>> 3;
    }

    public static long bits2words(long numBits) {
        return (numBits - 1L >>> 6) + 1L;
    }

    @Override
    public void close() {
        if (this.baseAddr != 0L) {
            DirectMemory.freeRaw(this.baseAddr);
            this.baseAddr = 0L;
        }
    }

    public long capacity() {
        return this.size << 6;
    }

    public boolean get(long index) {
        return this.unsafeGet(this.checkBounds(index));
    }

    public boolean unsafeGet(long index) {
        long word = index >> 6;
        long bitmask = 1L << (int)index;
        return (JavaInternals.unsafe.getLong(this.baseAddr + word * 8L) & bitmask) != 0L;
    }

    public void set(long index) {
        this.unsafeSet(this.checkBounds(index));
    }

    public void unsafeSet(long index) {
        long word = index >> 6;
        long bitmask = 1L << (int)index;
        long wordAddr = this.baseAddr + word * 8L;
        JavaInternals.unsafe.putLong(wordAddr, JavaInternals.unsafe.getLong(wordAddr) | bitmask);
    }

    public void clear(long index) {
        this.unsafeClear(this.checkBounds(index));
    }

    public void unsafeClear(long index) {
        long word = index >> 6;
        long bitmask = 1L << (int)index;
        long wordAddr = this.baseAddr + word * 8L;
        JavaInternals.unsafe.putLong(wordAddr, JavaInternals.unsafe.getLong(wordAddr) & (bitmask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public void clear() {
        DirectMemory.clear(this.baseAddr, this.size * 8L);
    }

    protected long checkBounds(long index) {
        if (index < 0L || index >> 6 >= this.size) {
            throw new IndexOutOfBoundsException(index + " is out of bounds");
        }
        return index;
    }
}

