/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import one.nio.os.perf.BreakpointType;
import one.nio.os.perf.CacheOp;
import one.nio.os.perf.CacheType;

public class PerfEvent
implements Serializable {
    private static final int PERF_TYPE_HARDWARE = 0;
    private static final int PERF_TYPE_SOFTWARE = 1;
    private static final int PERF_TYPE_TRACEPOINT = 2;
    private static final int PERF_TYPE_HW_CACHE = 3;
    private static final int PERF_TYPE_RAW_CPU = 4;
    private static final int PERF_TYPE_BREAKPOINT = 5;
    public static final PerfEvent HW_CPU_CYCLES = new PerfEvent("HW_CPU_CYCLES", 0, 0L);
    public static final PerfEvent HW_INSTRUCTIONS = new PerfEvent("HW_INSTRUCTIONS", 0, 1L);
    public static final PerfEvent HW_CACHE_REFERENCES = new PerfEvent("HW_CACHE_REFERENCES", 0, 2L);
    public static final PerfEvent HW_CACHE_MISSES = new PerfEvent("HW_CACHE_MISSES", 0, 3L);
    public static final PerfEvent HW_BRANCH_INSTRUCTIONS = new PerfEvent("HW_BRANCH_INSTRUCTIONS", 0, 4L);
    public static final PerfEvent HW_BRANCH_MISSES = new PerfEvent("HW_BRANCH_MISSES", 0, 5L);
    public static final PerfEvent HW_BUS_CYCLES = new PerfEvent("HW_BUS_CYCLES", 0, 6L);
    public static final PerfEvent HW_STALLED_CYCLES_FRONTEND = new PerfEvent("HW_STALLED_CYCLES_FRONTEND", 0, 7L);
    public static final PerfEvent HW_STALLED_CYCLES_BACKEND = new PerfEvent("HW_STALLED_CYCLES_BACKEND", 0, 8L);
    public static final PerfEvent HW_REF_CPU_CYCLES = new PerfEvent("HW_REF_CPU_CYCLES", 0, 9L);
    public static final PerfEvent SW_CPU_CLOCK = new PerfEvent("SW_CPU_CLOCK", 1, 0L);
    public static final PerfEvent SW_TASK_CLOCK = new PerfEvent("SW_TASK_CLOCK", 1, 1L);
    public static final PerfEvent SW_PAGE_FAULTS = new PerfEvent("SW_PAGE_FAULTS", 1, 2L);
    public static final PerfEvent SW_CONTEXT_SWITCHES = new PerfEvent("SW_CONTEXT_SWITCHES", 1, 3L);
    public static final PerfEvent SW_CPU_MIGRATIONS = new PerfEvent("SW_CPU_MIGRATIONS", 1, 4L);
    public static final PerfEvent SW_PAGE_FAULTS_MIN = new PerfEvent("SW_PAGE_FAULTS_MIN", 1, 5L);
    public static final PerfEvent SW_PAGE_FAULTS_MAJ = new PerfEvent("SW_PAGE_FAULTS_MAJ", 1, 6L);
    public static final PerfEvent SW_ALIGNMENT_FAULTS = new PerfEvent("SW_ALIGNMENT_FAULTS", 1, 7L);
    public static final PerfEvent SW_EMULATION_FAULTS = new PerfEvent("SW_EMULATION_FAULTS", 1, 8L);
    public static final PerfEvent SW_DUMMY = new PerfEvent("SW_DUMMY", 1, 9L);
    public static final PerfEvent SW_BPF_OUTPUT = new PerfEvent("SW_BPF_OUTPUT", 1, 10L);
    final String name;
    final int type;
    final long config;
    final int breakpoint;

    private PerfEvent(String name, int type, long config) {
        this(name, type, config, 0);
    }

    private PerfEvent(String name, int type, long config, int breakpoint) {
        this.name = name;
        this.type = type;
        this.config = config;
        this.breakpoint = breakpoint;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof PerfEvent) {
            PerfEvent other = (PerfEvent)o;
            return this.type == other.type && this.config == other.config && this.breakpoint == other.breakpoint;
        }
        return false;
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + (int)(this.config ^ this.config >>> 32);
        result = 31 * result + this.breakpoint;
        return result;
    }

    public static PerfEvent cache(CacheType type, CacheOp op) {
        int opval = op.ordinal();
        return new PerfEvent("HW_CACHE_" + type.name() + "_" + op.name(), 3, type.ordinal() | opval % 3 << 8 | opval / 3 << 16);
    }

    public static PerfEvent raw(long config) {
        return PerfEvent.raw(4, config);
    }

    public static PerfEvent raw(int type, long config) {
        return new PerfEvent("RAW:" + type + ":" + Long.toHexString(config), type, config);
    }

    public static PerfEvent tracepoint(int id) {
        return new PerfEvent("TRACEPOINT:" + id, 2, id);
    }

    public static PerfEvent tracepoint(String name) throws IOException {
        return PerfEvent.tracepoint(name, "/sys/kernel/debug");
    }

    public static PerfEvent tracepoint(String name, String debugfs) throws IOException {
        if (name.indexOf(58) < 0 || name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Invalid tracepoint name: " + name);
        }
        String fileName = debugfs + "/tracing/events/" + name.replace(':', '/') + "/id";
        byte[] idBytes = Files.readAllBytes(Paths.get(fileName, new String[0]));
        long id = Long.parseLong(new String(idBytes, StandardCharsets.ISO_8859_1));
        return new PerfEvent("TRACEPOINT:" + name, 2, id);
    }

    public static PerfEvent breakpoint(BreakpointType type, int len, long addr) {
        if (len != 1 && len != 2 && len != 4 && len != 8) {
            throw new IllegalArgumentException("Invalid breakpoint length: " + len);
        }
        return new PerfEvent("BREAKPOINT:" + type.name() + ':' + Long.toHexString(addr), 5, addr, type.ordinal() | len << 8);
    }

    public static int getEventType(String name) throws IOException {
        return Integer.parseInt(Files.readAllLines(Paths.get("/sys/bus/event_source/devices/" + name + "/type", new String[0])).get(0).trim());
    }
}

