/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.ObjectInput;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Json;
import one.nio.serial.JsonReader;
import one.nio.serial.Origin;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.serial.gen.StubGenerator;

public class CollectionSerializer
extends Serializer<Collection> {
    private MethodHandle constructor = this.findConstructor();

    CollectionSerializer(Class cls) {
        super(cls);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(in);
        }
        catch (ClassNotFoundException e) {
            if ((Repository.getOptions() & 2) == 0) {
                throw e;
            }
            this.cls = StubGenerator.generateRegular(this.uniqueName("List"), "java/util/ArrayList", null);
            this.origin = Origin.GENERATED;
        }
        this.constructor = this.findConstructor();
    }

    @Override
    public void calcSize(Collection obj, CalcSizeStream css) throws IOException {
        css.count += 4;
        for (Object v : obj) {
            css.writeObject(v);
        }
    }

    @Override
    public void write(Collection obj, DataStream out) throws IOException {
        out.writeInt(obj.size());
        for (Object v : obj) {
            out.writeObject(v);
        }
    }

    @Override
    public Collection read(DataStream in) throws IOException, ClassNotFoundException {
        Collection result;
        try {
            result = this.constructor.invokeExact();
            in.register(result);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            result.add(in.readObject());
        }
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            in.readObject();
        }
    }

    @Override
    public void toJson(Collection obj, StringBuilder builder) throws IOException {
        builder.append('[');
        Iterator iterator = obj.iterator();
        if (iterator.hasNext()) {
            Json.appendObject(builder, iterator.next());
            while (iterator.hasNext()) {
                builder.append(',');
                Json.appendObject(builder, iterator.next());
            }
        }
        builder.append(']');
    }

    @Override
    public Collection fromJson(JsonReader in) throws IOException, ClassNotFoundException {
        return in.readArray();
    }

    private MethodHandle findConstructor() {
        try {
            return MethodHandles.publicLookup().findConstructor(this.cls, MethodType.methodType(Void.TYPE)).asType(MethodType.methodType(Collection.class));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            if (this.cls == Collections.EMPTY_LIST.getClass()) {
                return MethodHandles.constant(Collection.class, Collections.EMPTY_LIST);
            }
            if (this.cls == Collections.EMPTY_SET.getClass()) {
                return MethodHandles.constant(Collection.class, Collections.EMPTY_SET);
            }
            if (this.cls == Collections.emptySortedSet().getClass()) {
                return MethodHandles.constant(Collection.class, Collections.emptySortedSet());
            }
            Class implementation = SortedSet.class.isAssignableFrom(this.cls) ? TreeSet.class : (Set.class.isAssignableFrom(this.cls) ? HashSet.class : (Queue.class.isAssignableFrom(this.cls) ? LinkedList.class : ArrayList.class));
            this.generateUid();
            Repository.log.warn("[" + Long.toHexString(this.uid) + "] No default constructor for " + this.descriptor + ", changed type to " + implementation.getName());
            try {
                return MethodHandles.publicLookup().findConstructor(implementation, MethodType.methodType(Void.TYPE)).asType(MethodType.methodType(Collection.class));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static boolean isValidType(Class<?> type) {
        try {
            type.getConstructor(new Class[0]);
            return (type.getModifiers() & 0x400) == 0;
        }
        catch (NoSuchMethodException e) {
            return type == Collection.class || type == List.class || type == Set.class || type == SortedSet.class || type == NavigableSet.class || type == Queue.class || type == Deque.class;
        }
    }
}

