/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.ObjectInput;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Json;
import one.nio.serial.JsonReader;
import one.nio.serial.Origin;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.serial.gen.StubGenerator;

public class MapSerializer
extends Serializer<Map> {
    private MethodHandle constructor = this.findConstructor();

    MapSerializer(Class cls) {
        super(cls);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(in);
        }
        catch (ClassNotFoundException e) {
            if ((Repository.getOptions() & 4) == 0) {
                throw e;
            }
            this.cls = StubGenerator.generateRegular(this.uniqueName("Map"), "java/util/HashMap", null);
            this.origin = Origin.GENERATED;
        }
        this.constructor = this.findConstructor();
    }

    @Override
    public void calcSize(Map obj, CalcSizeStream css) throws IOException {
        css.count += 4;
        for (Map.Entry e : obj.entrySet()) {
            css.writeObject(e.getKey());
            css.writeObject(e.getValue());
        }
    }

    @Override
    public void write(Map obj, DataStream out) throws IOException {
        out.writeInt(obj.size());
        for (Map.Entry e : obj.entrySet()) {
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
        }
    }

    @Override
    public Map read(DataStream in) throws IOException, ClassNotFoundException {
        Map result;
        try {
            result = this.constructor.invokeExact();
            in.register(result);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            result.put(in.readObject(), in.readObject());
        }
        return result;
    }

    @Override
    public void skip(DataStream in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            in.readObject();
            in.readObject();
        }
    }

    @Override
    public void toJson(Map obj, StringBuilder builder) throws IOException {
        builder.append('{');
        boolean firstWritten = false;
        for (Map.Entry entry : obj.entrySet()) {
            if (firstWritten) {
                builder.append(',');
            } else {
                firstWritten = true;
            }
            Json.appendString(builder, entry.getKey().toString());
            builder.append(':');
            Json.appendObject(builder, entry.getValue());
        }
        builder.append('}');
    }

    @Override
    public Map fromJson(JsonReader in) throws IOException, ClassNotFoundException {
        return in.readMap();
    }

    private MethodHandle findConstructor() {
        try {
            return MethodHandles.publicLookup().findConstructor(this.cls, MethodType.methodType(Void.TYPE)).asType(MethodType.methodType(Map.class));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            if (this.cls == Collections.EMPTY_MAP.getClass()) {
                return MethodHandles.constant(Map.class, Collections.EMPTY_MAP);
            }
            if (this.cls == Collections.emptySortedMap().getClass()) {
                return MethodHandles.constant(Map.class, Collections.emptySortedMap());
            }
            Class implementation = ConcurrentNavigableMap.class.isAssignableFrom(this.cls) ? ConcurrentSkipListMap.class : (ConcurrentMap.class.isAssignableFrom(this.cls) ? ConcurrentHashMap.class : (SortedMap.class.isAssignableFrom(this.cls) ? TreeMap.class : HashMap.class));
            this.generateUid();
            Repository.log.warn("[" + Long.toHexString(this.uid) + "] No default constructor for " + this.descriptor + ", changed type to " + implementation.getName());
            try {
                return MethodHandles.publicLookup().findConstructor(implementation, MethodType.methodType(Void.TYPE)).asType(MethodType.methodType(Map.class));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static boolean isValidType(Class<?> type) {
        try {
            type.getConstructor(new Class[0]);
            return (type.getModifiers() & 0x400) == 0;
        }
        catch (NoSuchMethodException e) {
            return type == Map.class || type == SortedMap.class || type == NavigableMap.class || type == ConcurrentMap.class || type == ConcurrentNavigableMap.class;
        }
    }
}

